package inventor.sample.dart;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.collision.SoCollisionManager;
import com.openinventor.inventor.collision.SoCollisionManager.CollidingPrimitive;
import com.openinventor.inventor.collision.SoCollisionManager.CollisionListener;
import com.openinventor.inventor.collision.SoCollisionManager.Filter;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.manips.SoTrackballManip;
import com.openinventor.inventor.manips.SoTransformManip;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.sensors.SoTimerSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  public class MyFilter implements Filter
  {

    @Override
    public boolean accept(SoPath arg0, SoPath scene)
    {
      if ( scene.regular.containsNode(m_dart_separator) )
        return false;
      return true;
    }
  }

  public class OnCollision implements CollisionListener
  {

    @Override
    public int collide(CollidingPrimitive arg0, CollidingPrimitive scene)
    {
      m_dart_has_reached_target = true;
      String name = scene.path.regular.getTail().getName();

      if ( name.equals("target_10") )
      {
        m_score += 10;
      }
      else if ( name.equals("target_50") )
      {
        m_score += 50;
      }
      else if ( name.equals("target_100") )
      {
        m_score += 100;
      }
      else if ( name.equals("target_500") )
      {
        m_score += 500;
      }
      else if ( name.equals("target_1000") )
      {
        m_score += 1000;
      }

      setScore();
      return SoCollisionManager.Resps.ABORT.getValue();
    }
  }

  public class OnTimer implements Runnable
  {

    @Override
    public void run()
    {
      if ( m_dart_translation[m_current_dart].translation.getValue().length() > 7 )
      {
        m_dart_visibility[m_current_dart].style.setValue(SoDrawStyle.Styles.INVISIBLE);
        m_timer.unschedule();
        newDart();
        return;
      }
      if ( m_dart_has_reached_target )
      {
        m_timer.unschedule();
        newDart();
        return;
      }
      m_dart_translation[m_current_dart].translation.setValue(m_dart_translation[m_current_dart].translation.getValue()
          .plus(new SbVec3f(0, 0, -0.25f)));
    }
  }

  public class OnKeyPress extends SoEventCallbackCB
  {
    @Override
    public void invoke(SoEventCallback event_cbk)
    {
      SoEvent event = event_cbk.getEvent();
      if ( SoKeyboardEvent.isKeyPressEvent(event, SoKeyboardEvent.Keys.SPACE) )
      {
        if ( m_game_over )
        {
          newGame();
          newDart();
        }
        else
        {
          m_dart_manip.replaceManip(m_dart_orientation_path[m_current_dart], null);
          m_timer.schedule();
        }
      }
    }
  }

  // Global objects
  private IViewerExaminer m_myViewer;
  int m_current_dart;
  SoSeparator m_root;
  SoTimerSensor m_timer;
  SoText3 m_score_text;
  SoSwitch m_cone_switch_material;
  SoSeparator m_dart_separator;
  SoTransformManip m_dart_manip;
  SoSeparator[] m_dart = new SoSeparator[3];
  SoTransform[] m_dart_orientation = new SoTransform[3];
  SoPath[] m_dart_orientation_path = new SoPath[3];
  SoPath[] m_dart_skeleton_path = new SoPath[3];
  SoSeparator[] m_dart_shape = new SoSeparator[3];
  SoTransform[] m_dart_translation = new SoTransform[3];
  SoPickStyle[] m_dart_pick_style = new SoPickStyle[3];
  SoDrawStyle[] m_dart_visibility = new SoDrawStyle[3];
  boolean m_game_over;
  int m_score;
  SoCollisionManager m_collision_manager;
  boolean m_dart_has_reached_target;

  @Override
  public void start()
  {
    m_myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Inventor shared objects
    // ---------------------------------------------------
    SoSeparator skeleton = new SoSeparator();
    skeleton.setName("skeleton");

    m_cone_switch_material = new SoSwitch();
    m_cone_switch_material.setName("m_cone_switch_material");
    m_cone_switch_material.whichChild.setValue(0);
    skeleton.addChild(m_cone_switch_material);

    SoDrawStyle invisible_cone_material = new SoDrawStyle();
    invisible_cone_material.setName("invisible_cone_material");
    invisible_cone_material.style.setValue(SoDrawStyle.Styles.INVISIBLE);
    m_cone_switch_material.addChild(invisible_cone_material);

    SoMaterial transparent_material = new SoMaterial();
    transparent_material.setName("transparent_material");
    transparent_material.diffuseColor.setValue(1, 1, 1);
    transparent_material.transparency.setValue(0.3f);
    m_cone_switch_material.addChild(transparent_material);

    SoTransform cone_transform_1 = new SoTransform();
    cone_transform_1.setName("cone_transform_1");
    cone_transform_1.rotation.setValue(new SbVec3f(0, 0, 1), (float) Math.PI);
    cone_transform_1.scaleFactor.setValue(0.08f, 0.08f, 0.08f);
    skeleton.addChild(cone_transform_1);

    SoTransform cone_transform_2 = new SoTransform();
    cone_transform_2.setName("cone_transform_2");
    cone_transform_2.translation.setValue(0, -1, 0);
    skeleton.addChild(cone_transform_2);

    SoCone cone = new SoCone();
    cone.setName("cone");
    cone.bottomRadius.setValue(0.5f);
    skeleton.addChild(cone);

    SoTransform dart_scale = new SoTransform();
    dart_scale.setName("dart_scale");
    dart_scale.scaleFactor.setValue(6.25f, 6.25f, 6.25f);
    dart_scale.rotation.setValue(new SbVec3f(1, 0, 0), (float) (Math.PI / 2.0f));

    m_dart_shape[0] = new SoSeparator();
    m_dart_shape[0].setName("m_dart_shape[0]");
    m_dart_shape[0].addChild(dart_scale);
    m_dart_shape[0].addChild(readSceneGraph("$OIVJHOME/data/blue_dart.iv"));
    m_dart_shape[0].addChild(skeleton);

    m_dart_shape[1] = new SoSeparator();
    m_dart_shape[1].setName("m_dart_shape[1]");
    m_dart_shape[1].addChild(dart_scale);
    m_dart_shape[1].addChild(readSceneGraph("$OIVJHOME/data/red_dart.iv"));
    m_dart_shape[1].addChild(skeleton);

    m_dart_shape[2] = new SoSeparator();
    m_dart_shape[2].setName("m_dart_shape[2]");
    m_dart_shape[2].addChild(dart_scale);
    m_dart_shape[2].addChild(readSceneGraph("$OIVJHOME/data/green_dart.iv"));
    m_dart_shape[2].addChild(skeleton);

    // Scene graph initialization
    // ------------------------------------------------
    m_root = new SoSeparator();
    m_root.setName("m_root");

    SoDirectionalLight dir_light = new SoDirectionalLight();
    dir_light.setName("dir_light");
    dir_light.direction.setValue(-1, -1, -10);
    dir_light.intensity.setValue(0.7f);
    m_root.addChild(dir_light);

    SoSeparator room = new SoSeparator();
    room.setName("room");
    m_root.addChild(room);

    SoTransform wall_transform = new SoTransform();
    wall_transform.setName("wall_transform");
    wall_transform.translation.setValue(0, 0, -5);
    room.addChild(wall_transform);

    SoSeparator wall_separator = new SoSeparator();
    wall_separator.setName("wall_separator");
    room.addChild(wall_separator);

    SoSeparator score = new SoSeparator();
    score.setName("score");
    wall_separator.addChild(score);

    SoMaterial score_mtl = new SoMaterial();
    score_mtl.setName("score_mtl");
    score_mtl.diffuseColor.setValue(0.0f, 0.8f, 1.0f);
    score.addChild(score_mtl);

    SoTransform score_transform = new SoTransform();
    score_transform.setName("score_transform");
    score_transform.translation.setValue(2.2f, -2.2f, 0.15f);
    score_transform.scaleFactor.setValue(0.07f, 0.07f, 0.07f);
    score.addChild(score_transform);

    m_score_text = new SoText3();
    m_score_text.setName("m_score_text");
    m_score_text.string.setValue("0000");
    m_score_text.justification.setValue(SoText3.Justifications.RIGHT);
    m_score_text.parts.setValue(SoText3.PartType.FRONT.getValue() + SoText3.PartType.SIDES.getValue());
    score.addChild(m_score_text);

    SoSeparator target = new SoSeparator();
    target.setName("target");
    room.addChild(target);

    SoMaterialBinding target_mtl_binding = new SoMaterialBinding();
    target_mtl_binding.setName("target_mtl_binding");
    target_mtl_binding.value.setValue(SoMaterialBinding.Bindings.OVERALL);
    target.addChild(target_mtl_binding);

    SoTransform target_transform = new SoTransform();
    target_mtl_binding.setName("target_mtl_binding");
    target_transform.rotation.setValue(new SbVec3f(1, 0, 0), (float) (Math.PI / 2.0f));
    target.addChild(target_transform);

    final int TARGET_NUM_POINTS = 25;
    float target_vertexes[][] = new float[TARGET_NUM_POINTS * 8][3];
    float alpha = 0.0f;
    for ( int i = 0; i < TARGET_NUM_POINTS; i++ )
    {
      target_vertexes[TARGET_NUM_POINTS * 0 + i][0] = (float) Math.cos(alpha) * 5.0f;
      target_vertexes[TARGET_NUM_POINTS * 0 + i][1] = 0.0f;
      target_vertexes[TARGET_NUM_POINTS * 0 + i][2] = (float) Math.sin(alpha) * 5.0f;
      target_vertexes[TARGET_NUM_POINTS * 1 + i][0] = (float) Math.cos(alpha) * 0.9f;
      target_vertexes[TARGET_NUM_POINTS * 1 + i][1] = 0.0f;
      target_vertexes[TARGET_NUM_POINTS * 1 + i][2] = (float) Math.sin(alpha) * 0.9f;
      target_vertexes[TARGET_NUM_POINTS * 2 + i][0] = (float) Math.cos(alpha) * 0.9f;
      target_vertexes[TARGET_NUM_POINTS * 2 + i][1] = 0.1f;
      target_vertexes[TARGET_NUM_POINTS * 2 + i][2] = (float) Math.sin(alpha) * 0.9f;
      target_vertexes[TARGET_NUM_POINTS * 3 + i][0] = (float) Math.cos(alpha) * 0.7f;
      target_vertexes[TARGET_NUM_POINTS * 3 + i][1] = 0.1f;
      target_vertexes[TARGET_NUM_POINTS * 3 + i][2] = (float) Math.sin(alpha) * 0.7f;
      target_vertexes[TARGET_NUM_POINTS * 4 + i][0] = (float) Math.cos(alpha) * 0.5f;
      target_vertexes[TARGET_NUM_POINTS * 4 + i][1] = 0.1f;
      target_vertexes[TARGET_NUM_POINTS * 4 + i][2] = (float) Math.sin(alpha) * 0.5f;
      target_vertexes[TARGET_NUM_POINTS * 5 + i][0] = (float) Math.cos(alpha) * 0.3f;
      target_vertexes[TARGET_NUM_POINTS * 5 + i][1] = 0.1f;
      target_vertexes[TARGET_NUM_POINTS * 5 + i][2] = (float) Math.sin(alpha) * 0.3f;
      target_vertexes[TARGET_NUM_POINTS * 6 + i][0] = (float) Math.cos(alpha) * 0.1f;
      target_vertexes[TARGET_NUM_POINTS * 6 + i][1] = 0.1f;
      target_vertexes[TARGET_NUM_POINTS * 6 + i][2] = (float) Math.sin(alpha) * 0.1f;
      target_vertexes[TARGET_NUM_POINTS * 7 + i][0] = (float) Math.cos(alpha) * 0.00001f;
      target_vertexes[TARGET_NUM_POINTS * 7 + i][1] = 0.1f;
      target_vertexes[TARGET_NUM_POINTS * 7 + i][2] = (float) Math.sin(alpha) * 0.00001f;
      alpha += (float) (2 * Math.PI / TARGET_NUM_POINTS);
    }
    SoCoordinate3 target_coords = new SoCoordinate3();
    target_coords.setName("target_coords");
    target_coords.point.setValues(0, target_vertexes);
    target.addChild(target_coords);

    SoSeparator out_sep = new SoSeparator();
    out_sep.setName("out_sep");
    target.addChild(out_sep);

    SoTexture2 out_target_mtl = new SoTexture2();
    out_target_mtl.setName("out_target_mtl");
    out_target_mtl.filename.setValue("$OIVJHOME/data/textures/rgb/wood.rgb");
    out_sep.addChild(out_target_mtl);

    int j;
    int target_indexes[] = new int[2 * (TARGET_NUM_POINTS + 1)];
    int ind = TARGET_NUM_POINTS * 0;
    target_indexes[2 * TARGET_NUM_POINTS] = ind;
    target_indexes[2 * TARGET_NUM_POINTS + 1] = ind + TARGET_NUM_POINTS;
    for ( j = 0; j < TARGET_NUM_POINTS; j++ )
    {
      target_indexes[j * 2] = ind;
      target_indexes[j * 2 + 1] = ind + TARGET_NUM_POINTS;
      ind++;
    }
    SoIndexedTriangleStripSet target_out = new SoIndexedTriangleStripSet();
    target_out.setName("target_out");
    target_out.coordIndex.setValues(0, target_indexes);
    out_sep.addChild(target_out);

    SoMaterial black_target_mtl = new SoMaterial();
    black_target_mtl.setName("black_target_mtl");
    black_target_mtl.diffuseColor.setValue(0, 0, 0);
    target.addChild(black_target_mtl);

    ind = TARGET_NUM_POINTS * 1;
    target_indexes[2 * TARGET_NUM_POINTS] = ind;
    target_indexes[2 * TARGET_NUM_POINTS + 1] = ind + TARGET_NUM_POINTS;
    for ( j = 0; j < TARGET_NUM_POINTS; j++ )
    {
      target_indexes[j * 2] = ind;
      target_indexes[j * 2 + 1] = ind + TARGET_NUM_POINTS;
      ind++;
    }
    SoIndexedTriangleStripSet target_edge = new SoIndexedTriangleStripSet();
    target_edge.setName("target_edge");
    target_edge.coordIndex.setValues(0, target_indexes);
    target.addChild(target_edge);

    ind = TARGET_NUM_POINTS * 2;
    target_indexes[2 * TARGET_NUM_POINTS] = ind;
    target_indexes[2 * TARGET_NUM_POINTS + 1] = ind + TARGET_NUM_POINTS;
    for ( j = 0; j < TARGET_NUM_POINTS; j++ )
    {
      target_indexes[j * 2] = ind;
      target_indexes[j * 2 + 1] = ind + TARGET_NUM_POINTS;
      ind++;
    }
    SoIndexedTriangleStripSet target_10 = new SoIndexedTriangleStripSet();
    target_10.setName("target_10");
    target_10.coordIndex.setValues(0, target_indexes);
    target.addChild(target_10);

    ind = TARGET_NUM_POINTS * 4;
    target_indexes[2 * TARGET_NUM_POINTS] = ind;
    target_indexes[2 * TARGET_NUM_POINTS + 1] = ind + TARGET_NUM_POINTS;
    for ( j = 0; j < TARGET_NUM_POINTS; j++ )
    {
      target_indexes[j * 2] = ind;
      target_indexes[j * 2 + 1] = ind + TARGET_NUM_POINTS;
      ind++;
    }
    SoIndexedTriangleStripSet target_100 = new SoIndexedTriangleStripSet();
    target_100.setName("target_100");
    target_100.coordIndex.setValues(0, target_indexes);
    target.addChild(target_100);

    SoMaterial yellow_target_mtl = new SoMaterial();
    yellow_target_mtl.setName("yellow_target_mtl");
    yellow_target_mtl.diffuseColor.setValue(1.0f, 0.9f, 0.0f);
    target.addChild(yellow_target_mtl);

    ind = TARGET_NUM_POINTS * 3;
    target_indexes[2 * TARGET_NUM_POINTS] = ind;
    target_indexes[2 * TARGET_NUM_POINTS + 1] = ind + TARGET_NUM_POINTS;
    for ( j = 0; j < TARGET_NUM_POINTS; j++ )
    {
      target_indexes[j * 2] = ind;
      target_indexes[j * 2 + 1] = ind + TARGET_NUM_POINTS;
      ind++;
    }
    SoIndexedTriangleStripSet target_50 = new SoIndexedTriangleStripSet();
    target_50.setName("target_50");
    target_50.coordIndex.setValues(0, target_indexes);
    target.addChild(target_50);

    ind = TARGET_NUM_POINTS * 5;
    target_indexes[2 * TARGET_NUM_POINTS] = ind;
    target_indexes[2 * TARGET_NUM_POINTS + 1] = ind + TARGET_NUM_POINTS;
    for ( j = 0; j < TARGET_NUM_POINTS; j++ )
    {
      target_indexes[j * 2] = ind;
      target_indexes[j * 2 + 1] = ind + TARGET_NUM_POINTS;
      ind++;
    }
    SoIndexedTriangleStripSet target_500 = new SoIndexedTriangleStripSet();
    target_500.setName("target_500");
    target_500.coordIndex.setValues(0, target_indexes);
    target.addChild(target_500);

    SoMaterial red_target_mtl = new SoMaterial();
    red_target_mtl.setName("red_target_mtl");
    red_target_mtl.diffuseColor.setValue(1, 0, 0);
    target.addChild(red_target_mtl);

    ind = TARGET_NUM_POINTS * 6;
    target_indexes[2 * TARGET_NUM_POINTS] = ind;
    target_indexes[2 * TARGET_NUM_POINTS + 1] = ind + TARGET_NUM_POINTS;
    for ( j = 0; j < TARGET_NUM_POINTS; j++ )
    {
      target_indexes[j * 2] = ind;
      target_indexes[j * 2 + 1] = ind + TARGET_NUM_POINTS;
      ind++;
    }
    SoIndexedTriangleStripSet target_1000 = new SoIndexedTriangleStripSet();
    target_1000.setName("target_1000");
    target_1000.coordIndex.setValues(0, target_indexes);
    target.addChild(target_1000);

    m_dart_separator = new SoSeparator();
    m_dart_separator.setName("m_dart_separator");
    m_root.addChild(m_dart_separator);

    // Keyboard event
    // ------------------------------------------------------------
    SoEventCallback event = new SoEventCallback();
    event.setName("event");
    event.addEventCallback(SoKeyboardEvent.class, new OnKeyPress());
    m_root.addChild(event);

    // Set up viewer
    // -------------------------------------------------------------
    SoCamera camera = m_myViewer.getRenderArea().getRootSceneGraph().getCamera();
    camera.position.setValue(-3.61f, -0.115f, 2.55f);
    camera.orientation.setValue(new SbVec3f(0, -1, 0), 0.77f);
    m_myViewer.setSceneGraph(m_root);

    // Moving timer
    // --------------------------------------------------------------
    m_timer = new SoTimerSensor(new OnTimer());
    m_timer.setInterval(new SbTime(0.1f));

    // Starting game
    // -------------------------------------------------------------
    m_dart_manip = new SoTrackballManip();

    newGame();
    newDart();

    final Component component = m_myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    m_myViewer.dispose();
  }

  private void newDart()
  {
    m_dart_has_reached_target = false;
    m_current_dart++;
    if ( m_current_dart == 3 )
    {
      m_collision_manager = null;
      m_game_over = true;
    }
    else
    {
      if ( m_collision_manager == null )
      {
        m_collision_manager = new SoCollisionManager(m_dart_skeleton_path[m_current_dart], m_root,
            m_dart_translation[m_current_dart]);
        m_collision_manager.setGluing(false);
        m_collision_manager.addCollisionListener(new OnCollision());
        m_collision_manager.setFilter(new MyFilter());
      }
      else
      {
        m_collision_manager.setObject(m_dart_skeleton_path[m_current_dart]);
        m_collision_manager.setTransform(m_dart_translation[m_current_dart]);
      }

      float d = (float) Math.random();
      float alpha = (float) ((Math.random() * Math.PI * 2.0f) - Math.PI);
      m_dart_pick_style[m_current_dart].style.setValue(SoPickStyle.Styles.SHAPE);
      m_dart_visibility[m_current_dart].style.setValue(SoDrawStyle.Styles.FILLED);
      m_dart_orientation[m_current_dart].translation.setValue(d * (float) Math.cos(alpha), d * (float) Math.sin(alpha),
          0);
      m_dart_manip.replaceNode(m_dart_orientation_path[m_current_dart]);
    }
  }

  private void newGame()
  {
    m_game_over = false;
    m_score = 0;
    setScore();

    m_dart_separator.removeAllChildren();
    for ( int i = 0; i < 3; i++ )
    {
      StringBuffer buff = new StringBuffer(256);
      buff.append("[" + i + "]");

      m_dart[i] = new SoSeparator();
      buff.append("m_dart[" + i + "]");
      m_dart[i].setName(buff.toString());

      m_dart_pick_style[i] = new SoPickStyle();
      buff.append("m_dart_pick_style[" + i + "]");
      m_dart_pick_style[i].setName(buff.toString());
      m_dart_pick_style[i].style.setValue(SoPickStyle.Styles.UNPICKABLE);
      m_dart[i].addChild(m_dart_pick_style[i]);

      m_dart_visibility[i] = new SoDrawStyle();
      buff.append("m_dart_visibility[" + i + "]");
      m_dart_visibility[i].setName(buff.toString());
      m_dart_visibility[i].style.setValue(SoDrawStyle.Styles.INVISIBLE);
      m_dart[i].addChild(m_dart_visibility[i]);

      m_dart_orientation[i] = new SoTransform();
      buff.append("m_dart_orientation[" + i + "]");
      m_dart_orientation[i].setName(buff.toString());
      m_dart[i].addChild(m_dart_orientation[i]);

      m_dart_translation[i] = new SoTransform();
      buff.append("m_dart_translation[" + i + "]");
      m_dart_translation[i].setName(buff.toString());
      m_dart[i].addChild(m_dart_translation[i]);

      m_dart[i].addChild(m_dart_shape[i]);

      m_dart_separator.addChild(m_dart[i]);

      m_dart_orientation_path[i] = new SoPath(m_root);
      m_dart_orientation_path[i].setName(buff.toString());
      m_dart_orientation_path[i].regular.append(m_dart_separator);
      m_dart_orientation_path[i].regular.append(m_dart[i]);
      m_dart_orientation_path[i].regular.append(m_dart_orientation[i]);

      m_dart_skeleton_path[i] = new SoPath(m_root);
      m_dart_skeleton_path[i].setName(buff.toString());
      m_dart_skeleton_path[i].regular.append(m_dart_separator);
      m_dart_skeleton_path[i].regular.append(m_dart[i]);
      m_dart_skeleton_path[i].regular.append(m_dart_shape[i]);
      m_dart_skeleton_path[i].regular.append(2);
    }
    m_current_dart = -1;
  }

  // ******************************************************************************
  // Setting score text
  private void setScore()
  {
    m_score_text.string.setValue(String.valueOf(m_score));
  }

  private static SoSeparator readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Dart");
  }
}
