package inventor.sample.depthBuffer;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoCoordinate3;
import com.openinventor.inventor.nodes.SoDepthBuffer;
import com.openinventor.inventor.nodes.SoFaceSet;
import com.openinventor.inventor.nodes.SoLineSet;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  SbVec3f[] vertices = new SbVec3f[]
  {
	new SbVec3f(1, 1, 0),
	new SbVec3f(1, -1, 0),
	new SbVec3f(-1, -1, 0),
    new SbVec3f(-1, 1, 0),
    new SbVec3f(1, 1, 0)
  };
  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    SoCoordinate3 coords = new SoCoordinate3();
    coords.point.setValues(0, vertices);

    SoShapeHints shapeHint = new SoShapeHints();
    shapeHint.vertexOrdering.setValue(SoShapeHints.VertexOrderings.COUNTERCLOCKWISE);

    SoFaceSet blueFace = new SoFaceSet();
    blueFace.numVertices.setValue(4);
    SoMaterial blueMat = new SoMaterial();
    blueMat.diffuseColor.setValue(0, 0, 1);
    SoDepthBuffer blueDepth = new SoDepthBuffer();
    blueDepth.range.setValue(0f, 1.0f);

    SoLineSet redLine = new SoLineSet();
    redLine.numVertices.setValue(5);
    SoMaterial redMat = new SoMaterial();
    redMat.diffuseColor.setValue(1, 0, 0);
    SoDepthBuffer redDepth = new SoDepthBuffer();
    redDepth.function.setValue(SoDepthBuffer.DepthWriteFunctions.ALWAYS);

    root.addChild(coords);
    root.addChild(shapeHint);

    root.addChild(blueDepth);
    root.addChild(blueMat);
    root.addChild(blueFace);

    root.addChild(redMat);
    root.addChild(redDepth);
    root.addChild(redLine);

    // attach and show viewer
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Depth buffer");
  }
}
