// MarkerSet
// Uses standard marker-index [0-89]
// and defines also 3 custom marker (index 90,91,92)
package inventor.sample.markerSet;

import java.awt.* ;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.lang.reflect.Field;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoCoordinate3;
import com.openinventor.inventor.nodes.SoLineSet;
import com.openinventor.inventor.nodes.SoMarkerSet;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoMaterialBinding;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private IViewerExaminer viewer;

  private SoMarkerSet markerSet;

  static private String markerSizeSuffix[] = {"_5_5", "_7_7", "_9_9"};
  private int markerSize=0;

  static private String markerStyleSuffix[] = {"_LINE","_FILLED"};
  private int markerStyle=0;
  private boolean useStyle = false;

  private String markerName = "CROSS";

  private TextField fieldMarkerIndex;
  private Choice choiceMarkerStyle;

  static Color UIBackgroundColor = new Color(148F/255F,174F/255F,211F/255F);
  static Color UIForegroundColor = Color.blue;
  static Color UIMarginColor = new Color(0,0,0.5F);
  static SbVec3f markersCoords[] = {
    new SbVec3f(0.5f,0.5f,0.f), new SbVec3f(1.5f,3.8f,0.f), new SbVec3f(1.8f,1.2f,0.f),
    new SbVec3f(2.4f,1.9f,0.f), new SbVec3f(3.2f,6.3f,0.f), new SbVec3f(4.5f,7.2f,0.f),
    new SbVec3f(6.3f,9.3f,0.f), new SbVec3f(6.9f,7.2f,0.f), new SbVec3f(8.0f,6.0f,0.f),
    new SbVec3f(8.5f,6.3f,0.f)
  };

  static SbColor markersColors[] = {
    new SbColor(1,0,0), new SbColor(0,1,0), new SbColor(0,0,1),
    new SbColor(1,1,1), new SbColor(1,1,0), new SbColor(1,0,1),
    new SbColor(0,1,1), new SbColor(1,0,0), new SbColor(0,1,0),
    new SbColor(0,0,1)
  };

  static byte arrowBits[] = {
    (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff,
    (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01,
    (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00,
    (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff,
    (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00,
    (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff,
    (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01,
    (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00,
    (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff,
    (byte)0x01, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0xff, (byte)0xff, (byte)0x01, (byte)0xff, (byte)0xff, (byte)0xff, (byte)0xff, (byte)0x01,
    (byte)0xfe, (byte)0xff, (byte)0xff, (byte)0xff, (byte)0x00, (byte)0xf8, (byte)0xff, (byte)0xff, (byte)0x3f, (byte)0x00, (byte)0xe0, (byte)0xff,
    (byte)0xff, (byte)0x0f, (byte)0x00, (byte)0xc0, (byte)0xff, (byte)0xff, (byte)0x03, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x01,
    (byte)0x00, (byte)0x00, (byte)0xfc, (byte)0x7f, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0xf8, (byte)0x1f, (byte)0x00, (byte)0x00, (byte)0x00,
    (byte)0xe0, (byte)0x07, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x80, (byte)0x01, (byte)0x00, (byte)0x00
  };

  static byte targetBits[] = {
    (byte)0xe0, (byte)0x0f, (byte)0x00, (byte)0x18, (byte)0x31, (byte)0x00, (byte)0x04, (byte)0x41, (byte)0x00, (byte)0xc2, (byte)0x87, (byte)0x00,
    (byte)0x22, (byte)0x89, (byte)0x00, (byte)0x11, (byte)0x11, (byte)0x01, (byte)0x09, (byte)0x21, (byte)0x01, (byte)0x09, (byte)0x21, (byte)0x01,
    (byte)0xff, (byte)0xff, (byte)0x01, (byte)0x09, (byte)0x21, (byte)0x01, (byte)0x09, (byte)0x21, (byte)0x01, (byte)0x11, (byte)0x11, (byte)0x01,
    (byte)0x22, (byte)0x89, (byte)0x00, (byte)0xc2, (byte)0x87, (byte)0x00, (byte)0x04, (byte)0x41, (byte)0x00, (byte)0x18, (byte)0x31, (byte)0x00,
    (byte)0xe0, (byte)0x0f, (byte)0x00
  };

  static byte tgsBits[] = {
    (byte)0xff, (byte)0xff, (byte)0x1f, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x1f, (byte)0x1f, (byte)0x1f, (byte)0x04, (byte)0x11, (byte)0x11,
    (byte)0x04, (byte)0x01, (byte)0x01, (byte)0x04, (byte)0x1d, (byte)0x1f, (byte)0x04, (byte)0x11, (byte)0x10, (byte)0x04, (byte)0x11, (byte)0x11,
    (byte)0x04, (byte)0x1f, (byte)0x1f, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x1f
  };

  static {
    SoMarkerSet.addMarker(90, new SbVec2s((short) 17, (short) 17), targetBits, true,true) ;
    SoMarkerSet.addMarker(91, new SbVec2s((short) 33, (short) 33), arrowBits, true,true) ;
    SoMarkerSet.addMarker(92, new SbVec2s((short) 21, (short) 11), tgsBits, true,true) ;
  }


  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("MarkerSet");
  }


  @Override
  public void start() {
    viewer = makeInventorGraphic();

    final Component component = viewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(makeUserInterface(), BorderLayout.WEST);
  }

  @Override
  public void stop()
  {
    viewer.dispose();
  }

  IViewerExaminer makeInventorGraphic () {
    final IViewerExaminer viewer = ViewerComponentsFactory.createViewerExaminer();

    SoCoordinate3 coords = new SoCoordinate3() ;
    coords.point.setValues(0, markersCoords) ;

    markerSet = new SoMarkerSet() ;
    markerSet.markerIndex.setValue(0) ;

    SoMaterialBinding matBind = new SoMaterialBinding();
    matBind.value.setValue(SoMaterialBinding.Bindings.PER_VERTEX);

    SoMaterial mat = new SoMaterial() ;
    mat.diffuseColor.setValues(0, markersColors);

    // Create the root of the scene graph
    SoSeparator root = new SoSeparator();
    { //assemble scene graph
      root.addChild(coords);
      root.addChild(new SoLineSet());
      root.addChild(matBind);
      root.addChild(mat);
      root.addChild(markerSet);
    }

    viewer.setSceneGraph(root) ;
    viewer.viewAll();

    return viewer;
  }


  Panel makeUserInterface() {

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints constraint = new GridBagConstraints();
    constraint.anchor = GridBagConstraints.WEST;
    constraint.insets.bottom = 10;
    constraint.insets.top = 10;
    constraint.insets.left = 10;
    constraint.insets.right = 10;

    Panel leftPanel = new Panel(gridbag) {
      @Override
      public void paint(Graphics g) {
	Dimension d = getSize() ;
	g.setColor(UIForegroundColor) ;
	int margin = 1;
	g.drawRect(margin,margin, d.width-2*margin, d.height-2*margin);
      }
    };
    leftPanel.setBackground(UIBackgroundColor);

    Label labelMarkerIndex = new Label("Marker index (0-92)");
    labelMarkerIndex.setForeground(UIForegroundColor);
    gridbag.setConstraints(labelMarkerIndex,constraint);
    leftPanel.add(labelMarkerIndex);

    fieldMarkerIndex = new TextField("",3);
    fieldMarkerIndex.addTextListener(new MarkerIndexListener());
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(fieldMarkerIndex,constraint);
    leftPanel.add(fieldMarkerIndex);

    Label labelMarkerSize = new Label("Marker size");
    labelMarkerSize.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelMarkerSize,constraint);
    leftPanel.add(labelMarkerSize);

    Choice choiceMarkerSize = new Choice();
    choiceMarkerSize.addItem("5");
    choiceMarkerSize.addItem("7");
    choiceMarkerSize.addItem("9");
    choiceMarkerSize.select(0) ;
    choiceMarkerSize.addItemListener(new SizeListener());
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(choiceMarkerSize,constraint);
    leftPanel.add(choiceMarkerSize);

    Label labelMarkerStyle = new Label("Marker style");
    labelMarkerStyle.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelMarkerStyle,constraint);
    leftPanel.add(labelMarkerStyle);

    choiceMarkerStyle = new Choice();
    choiceMarkerStyle.addItem("LINE");
    choiceMarkerStyle.addItem("FILLED");
    choiceMarkerStyle.select(0) ;
    choiceMarkerStyle.addItemListener(new StyleListener());
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(choiceMarkerStyle,constraint);
    leftPanel.add(choiceMarkerStyle);

    String markerType1[] = {
      "CROSS",    "PLUS",    "MINUS",    "SLASH",    "BACKSLASH",
      "BAR",   "STAR",    "Y",    "LIGHTNING",    "WELL"
    };
    String markerType2[] = {
      "CIRCLE",      "SQUARE",      "DIAMOND",      "TRIANGLE",
      "RHOMBUS",      "HOURGLASS",      "SATELLITE",      "PINE_TREE",
      "CAUTION",      "SHIP"
    };

    Checkbox box;
    CheckboxGroup cbgMarkerType = new CheckboxGroup();
    for (int i=0; i<markerType1.length; i++) {
      box = new Checkbox(markerType1[i], cbgMarkerType, false);
      box.addItemListener(new NameListener());
      constraint.gridwidth = 1;
      gridbag.setConstraints(box,constraint);
      leftPanel.add(box);

      box = new Checkbox(markerType2[i], cbgMarkerType, false);
      box.addItemListener(new NameStyleListener());
      constraint.gridwidth = GridBagConstraints.REMAINDER;
      gridbag.setConstraints(box,constraint);
      leftPanel.add(box);
    }

    Label emptyLabel = new Label();
    constraint.weighty = 1;
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(emptyLabel,constraint);
    leftPanel.add(emptyLabel);

    return leftPanel;
  }

  class MarkerIndexListener implements TextListener {
    @Override
    public void textValueChanged(TextEvent e) {
      TextField f = (TextField)e.getSource();
      int marker_index;
      try {
        marker_index = Integer.parseInt(f.getText());
        markerSet.markerIndex.setValue(marker_index);
      } catch (NumberFormatException exc) {
        return;
      }
    }
  }

  class SizeListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent event) {
      Choice c = (Choice)event.getSource();
      setMarker(markerName,useStyle,markerStyle,c.getSelectedIndex());
    }
  }

  class NameListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent event) {
      Checkbox box = (Checkbox)event.getSource();
      setMarker(box.getLabel(),false,markerStyle,markerSize);
    }
  }

  class NameStyleListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent event) {
      Checkbox box = (Checkbox)event.getSource();
      setMarker(box.getLabel(),true,markerStyle,markerSize);
    }
  }

  class StyleListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent event) {
      Choice c = (Choice)event.getSource();
      setMarker(markerName,useStyle,c.getSelectedIndex(),markerSize);
    }
  }

  private void setMarker(String marker_name, boolean use_style, int marker_style, int marker_size) {
    try {
      String field_name;
      if (use_style)
        field_name = marker_name + markerStyleSuffix[marker_style] + markerSizeSuffix[marker_size];
      else
        field_name = marker_name + markerSizeSuffix[marker_size];
      Field field = SoMarkerSet.class.getDeclaredField(field_name);
      int marker_index = field.getInt(markerSet);
      markerSet.markerIndex.setValue(marker_index);
      fieldMarkerIndex.setText(Integer.toString(marker_index));
      markerName = marker_name;
      markerSize = marker_size;
      markerStyle = marker_style;
      useStyle = use_style;
      choiceMarkerStyle.setEnabled(useStyle);
    } catch (Exception exc) {
    }

  }

}

