package inventor.sample.octreeAndSplitAction;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.actions.SoSplitGeometryAction;
import com.openinventor.inventor.nodes.SoOctreeOrdering;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create the root :
    SoSeparator myRoot = new SoSeparator();

    // read the file
    SoSeparator myScene;

    myScene = readSceneGraph("$OIVJHOME/data/crater.iv");

    // create the action... :
    SoSplitGeometryAction mySplitAction = new SoSplitGeometryAction(2, 2);
    mySplitAction.setSmartSplitting(true);
    mySplitAction.setDistinguishSplitParts(true);

    // ... and split the scene :
    mySplitAction.apply(myScene);

    // create the octree :
    SoOctreeOrdering myOctree = new SoOctreeOrdering();
    myOctree.dropCulling.setValue(true);
    myOctree.adjustDecimation.setValue(false);
    myOctree.dropScreenArea.setValue(1);

    // create scene graph :
    myRoot.addChild(myOctree);
    myOctree.addChild(myScene);

    myViewer.setSceneGraph(myRoot);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private static SoSeparator readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Octree and SplitAction");
  }
}
