package inventor.sample.polygonOffset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JPanel;

import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoPolygonOffset;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

import util.Example;
import util.ViewerComponentsFactory;


/**
  * This simple example shows the effect of the node SoPolygonOffset
  * on a sphere. The sphere is drawn 2 times, but the SoPolygonOffset
  * is applied to only one in order to see the difference.
  *
  * @author Jean-Michel Godinaud
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main (String [] argv) {
    Main example = new Main();
    example.demoMain("Polygon Offset");
  }

  public Main() {}

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSphere sphere = new SoSphere() ;

    SoDrawStyle lineStyle = new SoDrawStyle();
    lineStyle.style.setValue(SoDrawStyle.Styles.LINES);

    SoDrawStyle filledStyle = new SoDrawStyle();
    filledStyle.style.setValue(SoDrawStyle.Styles.FILLED);

    SoMaterial red = new SoMaterial();
    red.diffuseColor.setValue(1,0,0);

    // This SoShapeHints is used to define an non solid
    // shape : it is used to show side effect of Polygon Offset
    // this should be used with a SoVertexShape
    // instead of a sphere
    SoShapeHints shapeHints = new SoShapeHints();
    shapeHints.shapeType.setValue(SoShapeHints.ShapeTypes.UNKNOWN_SHAPE_TYPE);

    SoSeparator spherePair = new SoSeparator() ;
    {
      spherePair.addChild(shapeHints);
      spherePair.addChild(lineStyle);
      spherePair.addChild(sphere);
      spherePair.addChild(red);
      spherePair.addChild(filledStyle);
      spherePair.addChild(sphere);
    }

    SoTranslation trans = new SoTranslation() ;
    trans.translation.setValue(2.5F, 0, 0) ;
    final SoPolygonOffset polygonOffset =  new SoPolygonOffset() ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(spherePair);
      root.addChild(trans);
      root.addChild(polygonOffset);
      root.addChild(spherePair);
    }

    // Create a viewer
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    // North panel
    SliderPanel unitSlider = new SliderPanel(0, 20000, 1);
    unitSlider.addInfoText("Unit");
    unitSlider.setInfoTextSize(new Dimension(50, 20));
    unitSlider.setTextFieldColumns(4);
    unitSlider.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        polygonOffset.units.setValue(value);
      }
    });
    SliderPanel factorSlider = new SliderPanel(0, 5, 1, 2);
    factorSlider.addInfoText("Factor");
    factorSlider.setInfoTextSize(new Dimension(50, 20));
    factorSlider.setTextFieldColumns(4);
    factorSlider.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        polygonOffset.factor.setValue(value);
      }
    });

    JPanel sliderPanel = new JPanel(new GridLayout(2,1));
    sliderPanel.add(unitSlider);
    sliderPanel.add(factorSlider);

    final Component component = myViewer.getComponent();
    component.setName("Polygon Offset");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(sliderPanel, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

}
