package inventor.sample.transTexture;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoTexture2;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    SoSeparator sepCube = new SoSeparator();
    root.addChild(sepCube);

    // Choose a texture
    // Default mode for texture = MODULATE
    SoTexture2 rock = new SoTexture2();
    sepCube.addChild(rock);
    rock.filename.setValue("$OIVJHOME/data/textures/rgb/sillyFace.rgb");

    SoMaterial mat = new SoMaterial();
    mat.diffuseColor.setValue(1.0f, 1.0f, 1.0f);
    mat.transparency.setValue(0.5f);
    sepCube.addChild(mat);

    // Make a cube
    sepCube.addChild(new SoCube());

    SoMaterial mat2 = new SoMaterial();
    mat2.diffuseColor.setValue(1.0f, 0.0f, 0.0f);
    root.addChild(mat2);

    SoSphere sphere = new SoSphere();
    sphere.radius.setValue(0.5f);
    root.addChild(sphere);

    myViewer.setSceneGraph(root);
    myViewer.viewAll();
    myViewer.getRenderArea().setTransparencyType(SoGLRenderAction.TransparencyTypes.DELAYED_ADD);

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Transparent Texture");
  }
}
