package inventor.sample.wellBore;

import java.io.*;

import com.openinventor.inventor.SbColor;

// Class to store a simple color map
public class ColorMap
{
  // Number of color values in map
  public int nColors;

  // Color values
  public SbColor[] colors;

  // Default constructor
  public ColorMap()
  {
    nColors = 0;
  }

  // Creates a colormap from text file
  static public ColorMap createFromFile(String fileName)
  {
    File file = new File(fileName);
    if ( !file.exists() )
    {
      System.err.println("*** Unable to open colormap file " + fileName);
      return null;
    }

    ColorMap map = new ColorMap();

    BufferedReader reader;
    try
    {
      reader = new BufferedReader(new FileReader(file));
      String line = null;
      while ( (line = reader.readLine()) != null )
      {
        if ( line.startsWith("#") || (line.length() == 0) )
          continue;

        if ( line.startsWith("nColors ") )
        {
          map.nColors = Integer.parseInt(line.substring(8));
          map.colors = new SbColor[map.nColors];

          for ( int i = 0; i < map.nColors; ++i )
          {
            String[] t = reader.readLine().split(" ");
            map.colors[i] = new SbColor();
            map.colors[i].setValue(Float.parseFloat(t[0]), Float.parseFloat(t[1]), Float.parseFloat(t[2]));
          }
        }
      }

      reader.close();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }

    return map;
  }

  public int getNColors()
  {
    return nColors;
  }

  public SbColor getColors(int i)
  {
    return colors[i];
  }
}
