package inventor.viewercomponents.awt.glcanvas.renderareaexaminer;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderAreaExaminer;

import util.Example;

public class Main extends Example
{

  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  private RenderAreaExaminer renderArea;

  @Override
  public void start()
  {
    renderArea = new RenderAreaExaminer();
    renderArea.setSceneGraph(new SoCone());
    renderArea.viewAll(new SbViewportRegion(WIDTH, HEIGHT));

    renderArea.setPreferredSize(new java.awt.Dimension(WIDTH, HEIGHT));
    setLayout(new BorderLayout());
    add(renderArea);
  }

  @Override
  public void stop()
  {
    renderArea.dispose();
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Open Inventor SoCone, using RenderAreaExaminer");
  }

}
