package inventor.viewercomponents.awt.glcanvas.renderareaguiintegration;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.viewers.ViewerExaminer;
import com.openinventor.ivtune.SoIvTune;

import util.Example;

public class Main extends Example
{
  private ViewerExaminer viewer;

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Simple AWT viewer");
  }

  @Override
  public void start()
  {
    setLayout(new BorderLayout());

    JMenuBar menubar = buildMenu();
    add(menubar, BorderLayout.NORTH);

    viewer = new ViewerExaminer();

    // open chair.iv
    SoNode sceneGraph = readSceneGraph("$OIVJHOME/data/models/chair.iv");

    SoSeparator root = new SoSeparator();
    {
      root.addChild(new SoGradientBackground());
      root.addChild(sceneGraph);
    }

    viewer.setSceneGraph(root);
    viewer.viewAll();

    viewer.setPreferredSize(new java.awt.Dimension(500, 500));
    add(viewer, BorderLayout.CENTER);
  }

  @Override
  public void stop()
  {
    viewer.dispose();
  }

  private JMenuBar buildMenu()
  {
    JPopupMenu.setDefaultLightWeightPopupEnabled(false);

    // Menu
    JMenu fileMenu = new JMenu("File");

    final FileFilter ivFileFilter = new FileFilter()
    {

      @Override
      public String getDescription()
      {
        return "Open-Inventor files";
      }

      @Override
      public boolean accept(File f)
      {
        if ( f == null )
          return false;
        if ( f.isDirectory() )
          return true;
        return f.getName().toLowerCase().endsWith(".iv");
      }
    };

    final JFileChooser ivFileChooser = new JFileChooser(
        new File(SoPreferences.getValue("OIVJHOME") + File.separator + "data" + File.separator + "models"));
    ivFileChooser.setFileFilter(ivFileFilter);
    ivFileChooser.removeChoosableFileFilter(ivFileChooser.getAcceptAllFileFilter());

    JMenuItem openIvFileItem = new JMenuItem("Open");

    openIvFileItem.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        if ( ivFileChooser.showOpenDialog(null) != JFileChooser.APPROVE_OPTION )
          return;
        String fileName = ivFileChooser.getSelectedFile().getAbsolutePath();
        SoNode node = readSceneGraph(fileName);
        viewer.setSceneGraph(node);
        viewer.viewAll();
      }
    });

    fileMenu.add(openIvFileItem);

    JMenuItem openIvTuneItem = new JMenuItem("Run IvTune");

    openIvTuneItem.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        SoIvTune.start(viewer.getRenderArea().getRootSceneGraph());
      }
    });

    fileMenu.add(openIvTuneItem);

    JMenuItem closeDemoItem = new JMenuItem("Exit");
    closeDemoItem.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        System.exit(0);
      }
    });
    fileMenu.add(closeDemoItem);

    JMenuBar menubar = new JMenuBar();
    menubar.add(fileMenu);
    return menubar;
  }

  private static SoNode readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }
}
