package medical.tools.roimanip;

import java.awt.BorderLayout;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.openinventor.medical.helpers.MedicalHelper;

import util.Example;

public class Main extends Example
{
  public static final String DATA = "/medical/data/files/3DHEAD.ldm";
  public static final String EXAMPLE_NAME = "Roi Manip";
  public static final String EXAMPLE_DESCRITPION = "This example shows how to use the node SoROIManip";
  private final static Logger LOGGER = Logger.getLogger(Main.class.getName());

  private RoiManipPanel m_examplePanel;

  public static void printHelp()
  {
    System.out.println("Launching example: " + EXAMPLE_NAME);
    System.out.println(EXAMPLE_DESCRITPION);
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain(EXAMPLE_NAME);
  }

  @Override
  public void start()
  {
    printHelp();

    // Load example resources
    File dataFile;
    try
    {
      dataFile = new File(Main.class.getResource(DATA).toURI());
    }
    catch (Exception e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load resources", e);
      return;
    }

    m_examplePanel = new RoiManipPanel(dataFile.toString());

    setPreferredSize(new java.awt.Dimension(MedicalHelper.WINDOW_WIDTH, MedicalHelper.WINDOW_HEIGHT));
    setLayout(new BorderLayout());
    add(m_examplePanel);
  }

  @Override
  public void stop()
  {
    m_examplePanel.destroy();
  }
}
