package medical.web.medicalremotermpr.service;

import java.io.File;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.openinventor.remoteviz.rendering.Service;
import com.openinventor.remoteviz.rendering.ServiceSettings;

public class Main
{
  public static final String IV = "/medical/web/medicalremotermpr/service/simpleVolumeRender.iv";
  public static final String INDEX = "/medical/web/medicalremotermpr/clients/html5/index.html";
  public static final String EXAMPLE_NAME = "Medical Remote MPR";
  public static final String EXAMPLE_DESCRIPTION = "This example shows how to create 4 viewers using Remoteviz";
  private final static Logger LOGGER = Logger.getLogger(Main.class.getName());
  private static boolean running = true;

  public static void printHelp()
  {
    System.out.println("Launching example: " + EXAMPLE_NAME);
    System.out.println(EXAMPLE_DESCRIPTION);
  }

  public static void main(String[] args)
  {
    printHelp();

    // Load example resources
    File ivFile, indexFile;
    try
    {
      ivFile = new File(Main.class.getResource(IV).toURI());
      indexFile = new File(Main.class.getResource(INDEX).toURI());
    }
    catch (Exception e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load resources", e);
      return;
    }

    // Instantiate a service settings class
    ServiceSettings settings = new ServiceSettings();
    // set the IP address used by the service
    settings.setIP("127.0.0.1");
    // set the port used by the service
    settings.setPort((short) 8080);

    // To use an VolumeViz extension with RemoteViz
    settings.setOivUsedExtensions(EnumSet.of(ServiceSettings.Extensions.VOLUMEVIZLDM));

    // Add a listener (enables to manage the service events)
    Service.instance().addListener(new MedicalRemoteMprService(ivFile.toString()));

    try
    {
      LOGGER.log(Level.INFO, "Starting service...");
      LOGGER.log(Level.INFO, "IP: " + settings.getIP());
      LOGGER.log(Level.INFO, "Hostname: " + settings.getHostname());

      if ( Service.instance().open(settings) )
      {
        Runtime.getRuntime().addShutdownHook(new Thread()
        {
          @Override
          public void run()
          {
            running = false;
          }
        });

        System.out.println("The service is running. Press Ctrl + C to stop.");
        System.out.println("Drag&Drop the file " + indexFile.toString() + " in your favorite HTML5 browser");

        while ( running )
        {
          // Processes all waiting RemoteViz events.
          Service.instance().dispatch();
          try
          {
            Thread.sleep(1);
          }
          catch (InterruptedException e)
          {
            LOGGER.log(Level.WARNING, "Failed to sleep");
          }
        }
      }
      else
      {
        LOGGER.log(Level.SEVERE, "Failed to open the service");
      }
    }
    finally
    {
      // Make sure that the service is closed
      if ( Service.instance().isRunning() )
        Service.instance().close();
    }
  }
}
