// AnimCurve : curve and timer sensor
package meshviz.graph.advanced.animCurve;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Random;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.sensors.SoTimerSensor;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.meshviz.graph.PoCurve;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final int NUM_POINTS = 50;
  private static final double DEFAULT_TIME_INTERVAL = 0.1; // sec

  SbVec2f[] points;
  PoCurve myCurve;
  PoDomain myDom;
  PoGroup2Axis my2Axis;
  int currentPointIndex;
  Random rand;
  SoTimerSensor schedulingSensor;
  boolean adjustAxis;

  private IRenderAreaInteractive renderArea;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("AnimCurve");
  }

  @Override
  public void start() {
    renderArea = makeInventorGraphic();

    final Component canvas = renderArea.getComponent();
    canvas.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(canvas);
    add(makeUserInterface(), BorderLayout.WEST);
  }

  @Override
  public void stop()
  {
    schedulingSensor.unschedule();
    schedulingSensor = null;
    renderArea.dispose();
  }

  class NewPointTask implements Runnable {
    @Override
    public void run() {
      int i;
      float newy,ymax;

      newy = (float)(50. * rand.nextFloat());
      points[currentPointIndex].setValue(currentPointIndex, newy);
      if(currentPointIndex == NUM_POINTS - 1) {
        currentPointIndex=0 ;
        myCurve.point.setNum(0) ;
      } else {
        currentPointIndex++ ;
	SbVec2f visiblePoints[] = new SbVec2f[currentPointIndex];
        ymax = newy;
        for (i=0; i < currentPointIndex; i++) {
	  visiblePoints[i] = points[i];
          float[] pt = points[i].getValue();
          ymax = Math.max(ymax, pt[1]);
        }
	if (adjustAxis == true) {
	  myDom.max.setValue(new SbVec3f(NUM_POINTS, ymax,0));
	  my2Axis.end.setValue(new SbVec2f(NUM_POINTS, ymax));
	}
        myCurve.point.setValues(0, visiblePoints);
      }
    }
  }


  private IRenderAreaInteractive makeInventorGraphic () {
    IRenderAreaInteractive viewer = ViewerComponentsFactory.createRenderAreaInteractive();

    // Create the root of the scene graph
    SoSeparator root = new SoSeparator();

    // Create the curve
    myCurve = new PoCurve();
    points = new SbVec2f[NUM_POINTS];
    for(int i=0; i<NUM_POINTS; i++) points[i]= new SbVec2f(0, 0);

    myCurve.point.setNum(0);
    myCurve.set("curvePointApp.material", "diffuseColor [1 0 0]");

    // Create a group of 2 axis
    my2Axis = new PoGroup2Axis();
    my2Axis.end.setValue(new SbVec2f(50, 50));
    my2Axis.xTitle.setValue("Randomize");
    my2Axis.set("xAxis.titleApp.material", "diffuseColor 1 0 0");
    my2Axis.set("appearance.material", "diffuseColor 1 1 0") ;
    adjustAxis = false;

    myDom = new PoDomain();
    myDom.min.setValue(new SbVec3f(0, 0, 0));
    myDom.max.setValue(new SbVec3f(50, 50, 0));

    { // assemble scene graph
      root.addChild(myDom);
      root.addChild(my2Axis);
      root.addChild(myCurve);
    }

    currentPointIndex = 0;
    rand = new Random(0);
    schedulingSensor = new SoTimerSensor(new NewPointTask());
    schedulingSensor.setInterval(new SbTime(DEFAULT_TIME_INTERVAL));
    schedulingSensor.schedule();

    viewer.setSceneGraph(root) ;
    viewer.viewAll(new SbViewportRegion(viewer.getComponent().getSize()));

    return viewer;
  }


  JPanel makeUserInterface()
  {

    GridBagLayout gridbag = new GridBagLayout();
    gridbag.rowHeights = new int[] {50, 50, 50, 50};
    JPanel leftPanel = new JPanel(gridbag);

    JLabel labelAxisTitle = new JLabel("Axis title");
    GridBagConstraints gbc_labelAxisTitle = new GridBagConstraints();
    gbc_labelAxisTitle.fill = GridBagConstraints.HORIZONTAL;
    gbc_labelAxisTitle.insets = new Insets(0, 0, 5, 5);
    gbc_labelAxisTitle.gridx = 0;
    gbc_labelAxisTitle.gridy = 0;
    leftPanel.add(labelAxisTitle, gbc_labelAxisTitle);

    JTextField fieldAxisTitle = new JTextField("Randomize", 10);
    fieldAxisTitle.addActionListener(new AxisTitleListener());
    GridBagConstraints gbc_fieldAxisTitle = new GridBagConstraints();
    gbc_fieldAxisTitle.anchor = GridBagConstraints.LINE_START;
    gbc_fieldAxisTitle.fill = GridBagConstraints.LINE_START;
    gbc_fieldAxisTitle.insets = new Insets(0, 0, 5, 0);
    gbc_fieldAxisTitle.gridx = 1;
    gbc_fieldAxisTitle.gridy = 0;
    leftPanel.add(fieldAxisTitle, gbc_fieldAxisTitle);

    JLabel labelAdjustAxis = new JLabel("Adjust axis");
    GridBagConstraints gbc_labelAdjustAxis = new GridBagConstraints();
    gbc_labelAdjustAxis.fill = GridBagConstraints.BOTH;
    gbc_labelAdjustAxis.insets = new Insets(0, 0, 5, 5);
    gbc_labelAdjustAxis.gridx = 0;
    gbc_labelAdjustAxis.gridy = 1;
    leftPanel.add(labelAdjustAxis, gbc_labelAdjustAxis);

    JCheckBox checkAdjustAxis = new JCheckBox("", false);
    checkAdjustAxis.addItemListener(new AdjustAxisListener());
    GridBagConstraints gbc_checkAdjustAxis = new GridBagConstraints();
    gbc_checkAdjustAxis.fill = GridBagConstraints.BOTH;
    gbc_checkAdjustAxis.insets = new Insets(0, 0, 5, 0);
    gbc_checkAdjustAxis.gridx = 1;
    gbc_checkAdjustAxis.gridy = 1;
    leftPanel.add(checkAdjustAxis, gbc_checkAdjustAxis);

    JLabel labelAnimate = new JLabel("Animate");
    GridBagConstraints gbc_labelAnimate = new GridBagConstraints();
    gbc_labelAnimate.fill = GridBagConstraints.BOTH;
    gbc_labelAnimate.insets = new Insets(0, 0, 5, 5);
    gbc_labelAnimate.gridx = 0;
    gbc_labelAnimate.gridy = 2;
    leftPanel.add(labelAnimate, gbc_labelAnimate);

    JCheckBox checkAnimate = new JCheckBox("", false);
    checkAnimate.addItemListener(new AnimateListener());
    checkAnimate.setSelected(true);
    GridBagConstraints gbc_checkAnimate = new GridBagConstraints();
    gbc_checkAnimate.fill = GridBagConstraints.BOTH;
    gbc_checkAnimate.insets = new Insets(0, 0, 5, 0);
    gbc_checkAnimate.gridx = 1;
    gbc_checkAnimate.gridy = 2;
    leftPanel.add(checkAnimate, gbc_checkAnimate);

    JLabel labelCurveType = new JLabel("Curve type");
    GridBagConstraints gbc_labelCurveType = new GridBagConstraints();
    gbc_labelCurveType.fill = GridBagConstraints.BOTH;
    gbc_labelCurveType.insets = new Insets(0, 0, 5, 5);
    gbc_labelCurveType.gridx = 0;
    gbc_labelCurveType.gridy = 3;
    leftPanel.add(labelCurveType, gbc_labelCurveType);

    Choice choiceCurveType = new Choice();
    choiceCurveType.addItem("polyline");
    choiceCurveType.addItem("smooth");
    choiceCurveType.addItem("histogram");
    choiceCurveType.select(0);
    choiceCurveType.addItemListener(new CurveTypeListener());
    GridBagConstraints gbc_choiceCurveType = new GridBagConstraints();
    gbc_choiceCurveType.anchor = GridBagConstraints.LINE_START;
    gbc_choiceCurveType.fill = GridBagConstraints.LINE_START;
    gbc_choiceCurveType.insets = new Insets(0, 0, 5, 0);
    gbc_choiceCurveType.gridx = 1;
    gbc_choiceCurveType.gridy = 3;
    leftPanel.add(choiceCurveType, gbc_choiceCurveType);

    JLabel labelSpeed = new JLabel("Speed");
    GridBagConstraints gbc_labelSpeed = new GridBagConstraints();
    gbc_labelSpeed.insets = new Insets(5, 0, 0, 0);
    gbc_labelSpeed.anchor = GridBagConstraints.NORTHWEST;
    gbc_labelSpeed.gridy = 4;
    gbc_labelSpeed.gridx = 0;
    leftPanel.add(labelSpeed, gbc_labelSpeed);

    SliderPanel speedSlider = new SliderPanel(0, 10, 0);
    speedSlider.addSliderPanelListener(new SpeedListener());
    GridBagConstraints gbc_speedSlider = new GridBagConstraints();
    gbc_speedSlider.weighty = 1.0;
    gbc_speedSlider.anchor = GridBagConstraints.NORTH;
    gbc_speedSlider.fill = GridBagConstraints.HORIZONTAL;
    gbc_speedSlider.gridx = 1;
    gbc_speedSlider.gridy = 4;
    leftPanel.add(speedSlider, gbc_speedSlider);

    return leftPanel;
  }

  class AxisTitleListener implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e)
    {
      JTextField f = (JTextField)e.getSource();
      my2Axis.xTitle.setValue(f.getText());
    }
  }

  class AnimateListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      JCheckBox cb = (JCheckBox)e.getSource();
      if (cb.isSelected())
	schedulingSensor.schedule();
      else
	schedulingSensor.unschedule();
    }
  }

  class AdjustAxisListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      JCheckBox cb = (JCheckBox)e.getSource();
      adjustAxis = cb.isSelected() ;
    }
  }

  class SpeedListener extends SliderPanel.Listener
  {
    @Override
    public void stateChanged(float value)
    {
      schedulingSensor.unschedule();
      double inter = DEFAULT_TIME_INTERVAL / (1.0 + value);
      schedulingSensor.setInterval(new SbTime(inter));
      schedulingSensor.schedule();
    }
  }

  class CurveTypeListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      Choice c = (Choice)e.getSource();
      switch (c.getSelectedIndex()) {
      case 0:
	myCurve.curveRep.setValue(PoCurve.CurveReps.CURVE_POLYLINE); break;
      case 1:
	myCurve.curveRep.setValue(PoCurve.CurveReps.CURVE_SMOOTH); break;
      default:
	myCurve.curveRep.setValue(PoCurve.CurveReps.CURVE_HISTO_X); break;
      }
    }
  }

}
