package meshviz.graph.advanced.multipleHistogram;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoHistogram;
import com.openinventor.meshviz.graph.PoHistogram.Types;
import com.openinventor.meshviz.graph.PoMultipleHistogram;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Multiple Histogram");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    final int NUM_ROW = 8 ;
    final int NUM_COL = 3 ;
    String[] month = {"JAN","FEB","MAR","APR","MAY","JUNE","JULY","AUG"} ;
    String[] facture = {"EAU","GAZ","EDF" } ;
    float[] value = {
      5, 4.1F, 3.3F,
      7, 2.8F, 1.3F,
      4, 2,    3,
      3, 2,    1.2F,
      6, 3.1F, 1.5F,
      5, 3.2F, 2.5F,
      4, 2.2F, 5.8F,
      3, 5.1F, 1.9F
    } ;
    SbColor[] colors = { new SbColor(0,0,1), new SbColor(1,0,0), new SbColor(0,0.7F,0)} ;

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(10, 10,0);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoMultipleHistogram histog = new PoMultipleHistogram(new SbVec2f(-3,0), 13,
							 Types.X,
							 NUM_ROW, NUM_COL,
							 value, month, facture) ;

    histog.set("valueTextApp.material", "diffuseColor 1 1 1") ;
    histog.set("nameTextApp.material", "diffuseColor 1 1 1") ;
    histog.set("sumTextApp.material", "diffuseColor 0.8 0 0") ;

    histog.valuePath.setValue(PoHistogram.TextPaths.PATH_UP) ;
    histog.color.setValues(0, colors) ;
    histog.valueFontSize.setValue(0.05F) ;
    histog.nameFontSize.setValue(0.07F) ;
    histog.sumFontSize.setValue(0.05F) ;

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(histog);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
