// DomainExample1
package meshviz.graph.mentor.domainExample1;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoRectangle;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Domain Example 1");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    // Create our first rectangle red and solid
    PoRectangle myRect1 = new PoRectangle() ;
    myRect1.p.setValue(0, 0) ;
    myRect1.q.setValue(10, 20) ;
    myRect1.set("appearance.material", "diffuseColor 1. 0. 0.");

    // Create our second rectangle green and hollow
    PoRectangle myRect2 =
      new PoRectangle(new SbVec2f(-20,-10), new SbVec2f(-10, 40)) ;
    myRect2.set("appearance.material", "diffuseColor 0. 1. 0.");
    myRect2.set("appearance.drawStyle", "style LINES");

    SoTranslation myTrans = new SoTranslation();
    myTrans.translation.setValue(20, 2, 0);

    // Domain definition using PoDomain property node.
    // The domain is 'inherited' through the scene graph.
    PoDomain myDom1 = new PoDomain();
    myDom1.setValues(new SbVec2f(0, 0), new SbVec2f(10, 20)) ;

    PoDomain myDom2 = new PoDomain();
    myDom2.setValues(new SbVec2f(-20, -10), new SbVec2f(-10, 40)) ;

    // Create the root of our scene graph
    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(myDom1);
      root.addChild(myRect1);
      root.addChild(myDom2);
      root.addChild(myTrans);
      root.addChild(myRect2);
    }

    // associate the scene
    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
