// DomainExample5
package meshviz.graph.mentor.domainExample5;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoRectangle;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Domain Example 5");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoDomain myDom = new PoDomain();
    myDom.min.setValue(-20, -10, -1);
    myDom.max.setValue(-10, 40, 1);
    myDom.transformType.setValue(PoDomain.TransformTypes.TRANSFORM_01);

    // Create our first rectangle green and hollow
    PoRectangle myRect = new PoRectangle() ;
    myRect.p.setValue(-20, -10) ;
    myRect.q.setValue(-10, 40) ;
    myRect.set("appearance.material", "diffuseColor 0. 1. 0.");
    myRect.set("appearance.drawStyle", "style LINES");

    //Create a sphere and apply transformations:
    SoSphere mySphere = new SoSphere();
    mySphere.radius.setValue(0.4f);
    SoTranslation myTrans = new SoTranslation();
    myTrans.translation.setValue(0.5f, 0.5f, 0);

    // Create the root of our scene graph
    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(myDom);
      root.addChild(myRect);
      root.addChild(myTrans);
      root.addChild(mySphere);
    }

    // associate the scene
    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
