// MultipleAxisExample : multiple axis with curve and histograms
package meshviz.graph.mentor.multipleAxisExample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoCartesianAxis;
import com.openinventor.meshviz.graph.PoCurve;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.graph.PoSingleHistogram;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final int NUM_POINTS = 50;

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Multiple Axis Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    // Create  X common axis
    PoLinearAxis myXAxis = new PoLinearAxis();
    myXAxis.set("appearance.material", "diffuseColor 0 0 0") ;
    myXAxis.start.setValue(new SbVec3f(0, -1, 0));
    myXAxis.end.setValue(13);
    myXAxis.type.setValue(PoCartesianAxis.Types.XY);

    // Create Y axis for the curve
    PoLinearAxis myCurveYAxis = new PoLinearAxis();
    myCurveYAxis.start.setValue(new SbVec3f(0, -1, 0));
    myCurveYAxis.set("appearance.material", "diffuseColor 0 0 0") ;
    myCurveYAxis.end.setValue(1);
    myCurveYAxis.type.setValue(PoCartesianAxis.Types.YX);

    // Create the curve
    PoCurve myCurve = new PoCurve();
    SbVec2f[] points = new SbVec2f[NUM_POINTS];
    double ang;
    int i;
    for(i=0, ang=0; i<NUM_POINTS; i++, ang += 4*Math.PI/NUM_POINTS)
      points[i]= new SbVec2f((float)ang, (float)(Math.sin(ang)));
    myCurve.point.setValues(0, points);
    myCurve.set("curvePointApp.material", "diffuseColor [1 0 0]");

    // Domain of the curve
    PoDomain myCurveDom = new PoDomain();
    myCurveDom.min.setValue(new SbVec3f(0,-1,0));
    myCurveDom.max.setValue(new SbVec3f(13, 1, 0));

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoAnnotation root = new SoAnnotation();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(myCurveDom);
      root.addChild(myXAxis);
      root.addChild(myCurveYAxis);
      root.addChild(myCurve);
    }

    // We compute the bounding box of the first axis system
    // So we will know how to translate the second Y axis
    SoGetBoundingBoxAction myAction =
      new SoGetBoundingBoxAction(new SbViewportRegion((short)1000, (short)1000));
    myAction.apply(root);
    float [] box = myAction.getBoundingBox().getBounds();


    // Create the bar chart
    PoSingleHistogram myHist = new PoSingleHistogram();
    myHist.start.setValue(0, 0);
    myHist.end.setValue(13);
    float[] values = {1, 10, 12, 3, -5, 15, 10, 7, -2, -10, 20, 3, 5};
    myHist.value.setValues(0,values);
    myHist.set("appearance.material", "diffuseColor 0 0 0") ;

    // Create Y axis for the bar chart
    PoLinearAxis myHistYAxis = new PoLinearAxis();
    myHistYAxis.start.setValue(new SbVec3f(box[0], -10, 0));
    myHistYAxis.set("appearance.material", "diffuseColor 0 0 0") ;
    myHistYAxis.end.setValue(20);
    myHistYAxis.type.setValue(PoCartesianAxis.Types.YX);

    // Domain of the histogram
    PoDomain myHistDom = new PoDomain();
    myHistDom.min.setValue(new SbVec3f(0, -10, 0));
    myHistDom.max.setValue(new SbVec3f(13, 20, 0));
    root.addChild(myHistDom);

    // Now we have to align horizontally the two Y axis
    SoTranslation myTrans = new SoTranslation();
    myTrans.translation.setValue(0, (-13.F/2.F) -  (-130.F/30.F), 0);

    // Complete the scene graph (The curve will be drawn after bar chart
    // The translation should only apply to the bar chart and its Y axis
    root.addChild(myTrans);
    root.addChild(myHistYAxis);
    root.addChild(myHist);

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
