// PlotHPGLExample
package meshviz.graph.mentor.plotHPGLExample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;

import com.openinventor.hardcopy.SoVectorizeAction;
import com.openinventor.hardcopy.SoVectorizeHPGLAction;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoAngularAxis;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Plot HPGL Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create the angular axis node
    PoAngularAxis angularAxis = new PoAngularAxis(0.5F ,0, 2.5F, 1, 0);

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(angularAxis);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    JButton button = new JButton("Write PlotOutput.hpgl");
    button.setSelected(false);
    button.setBorder(BorderFactory.createRaisedBevelBorder());
    button.addMouseListener(new WriteMouseAdapter(root));

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(button, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  class WriteMouseAdapter extends MouseAdapter {
    SoSeparator m_sep;

    public WriteMouseAdapter(SoSeparator sep) {
      m_sep = sep;
    }

    @Override
    public void mousePressed(MouseEvent e) {
      // Create and apply the HPGL action.
      SoVectorizeHPGLAction vect = new SoVectorizeHPGLAction();

      vect.setStartPosition(10, 20);
      vect.setDrawingDimensions(130, 100);
      vect.setOrientation(SoVectorizeAction.Orientations.PORTRAIT);

      // width = 0.35mm.
      vect.setBorder(1, new SbColor(0, 0, 0));
      vect.setBackgroundColor(true, new SbColor(1, 1, 1));
      vect.setColorTranslationMethod(SoVectorizeAction.ColorTranslationMethods.AS_IS);
      vect.setLineEndStyle(SoVectorizeAction.EndLineStyles.BUTT_END);
      vect.setLineJoinsStyle(SoVectorizeAction.JoinLineStyles.ROUNDED_JOIN);
      vect.setMiterLimit(2);

      vect.getHPGLVectorOutput().openFile("PlotOutput.hpgl");
      vect.apply(m_sep);
      vect.getHPGLVectorOutput().closeFile();
    }
  }
}

