// SimpleCurveExample
package meshviz.graph.mentor.simpleCurveExample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoCurve;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final int NUM_POINTS = 50;

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Simple Curve Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    // Create the curve
    PoCurve myCurve = new PoCurve();

    SbVec2f[] points = new SbVec2f[NUM_POINTS];
    double ang;
    int i;

    for(i=0, ang=0; i<NUM_POINTS; i++, ang += 4*Math.PI/NUM_POINTS)
      points[i]= new SbVec2f((float)ang, (float)(6 * Math.sin(ang)));

    myCurve.point.setValues(0, points);
    myCurve.curveRep.setValue(PoCurve.CurveReps.CURVE_POLYLINE);
    myCurve.isCurveFilled.setValue(true);
    myCurve.raiseFilterType.setValue(PoCurve.FilterTypes.X_PERIOD);
    myCurve.raiseXPeriod.setValue((float)(Math.PI/3));
    myCurve.raiseThreshold.setValue(0);
    myCurve.markerFilterType.setValue(PoCurve.FilterTypes.X_PERIOD);
    myCurve.markerXPeriod.setValue((float)Math.PI);
    myCurve.set("markerApp.material", "diffuseColor [0 0 0]");
    myCurve.set("markerApp.drawStyle", "pointSize 5.0");
    myCurve.set("curvePointApp.material", "diffuseColor [1 0 0]");
    myCurve.set("curveFillingApp.material", "diffuseColor [0 0 1]");

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoAnnotation root = new SoAnnotation();
    root.addChild(background);
    root.addChild(myCurve);

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
