package meshviz.graph.sample.arrow3;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoArrow3;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SbVec3f[] arrowPts = {new SbVec3f(0.5F, 0.4F, 0), new SbVec3f(0.7F, 0.5F, 0.2F)} ;

    PoArrow3 arrow = new PoArrow3(arrowPts, PoArrow3.PatternTypes.DIRECT_TRIANGLE, PoArrow3.PatternTypes.DIRECT_TRIANGLE) ;
    arrow.set("bodyApp.material", "diffuseColor [1 0 0]") ;
    arrow.set("startApp.material", "diffuseColor [0 1 0]") ;
    arrow.set("endApp.material", "diffuseColor [0 0 1]") ;

    SoAnnotation root = new SoAnnotation() ;
    root.addChild(arrow) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Arrow3");
  }
}
