package meshviz.graph.sample.curve;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCurve;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{
  private static final float PERIOD_X = 0.5F;

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(10, 10,0);

    SbVec2f[] curvePts= {new SbVec2f(0.5F,0.5F), new SbVec2f(1.5F,3.8F), new SbVec2f(1.8F,1.2F),
			 new SbVec2f(2.4F,1.9F), new SbVec2f(3.2F,6.3F), new SbVec2f(4.5F,7.2F),
			 new SbVec2f(6.3F,9.3F), new SbVec2f(6.9F,7.2F), new SbVec2f(8,6),
			 new SbVec2f(8.5F,6.3F), new SbVec2f(9,7.5F),    new SbVec2f(9.5F,4.1F),
			 new SbVec2f(9.8F,3.5F), new SbVec2f(10F,1.5F)} ;

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoCurve curve = new PoCurve(curvePts) ;

    curve.curveRep.setValue(PoCurve.CurveReps.CURVE_SMOOTH) ;
    curve.raiseFilterType.setValue(PoCurve.FilterTypes.X_PERIOD) ;
    curve.raiseXPeriod.setValue(PERIOD_X) ;
    curve.raiseThreshold.setValue(0) ;
    curve.isCurveFilled.setValue(true) ;

    curve.markerFilterType.setValue(PoCurve.FilterTypes.X_PERIOD) ;
    curve.markerXPeriod.setValue(PERIOD_X) ;

    curve.set("markerApp.material", "diffuseColor [0 1 0]") ;
    curve.set("markerApp.drawStyle", "pointSize 5.0") ;
    curve.set("curvePointApp.material", "diffuseColor [1 0 0]") ;
    curve.set("curveFillingApp.material", "diffuseColor [0 0 1]") ;

    PoGroup2Axis g2Axis = new PoGroup2Axis(new SbVec2f(0,0), new SbVec2f(10, 10),
					   PoGroup2Axis.AxisTypes.LINEAR,
					   PoGroup2Axis.AxisTypes.LINEAR, "X-Axis", "Y-Axis") ;

    SoAnnotation root = new SoAnnotation() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(curve) ;
      root.addChild(g2Axis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Curve");
  }
}
