package meshviz.graph.sample.cylindricalBar;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCylindricalBar;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;
import com.openinventor.meshviz.nodes.PoRegularMesh1D;

import util.Example;
import util.ViewerComponentsFactory;

/*----------------------------------------------------------------------------*/

public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    float y[] = {
        0.5F, 3.8F, 1.2F, 7.2F, 9.3F, 7.2F, 6.0F, 7.5F, 4.1F, 1.5F};

    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoDomain myDomain = new PoDomain();
    myDomain.min.setValue(0, 0, 0);
    myDomain.max.setValue(10, 10, 10);

    PoMiscTextAttr myTextAttr = new PoMiscTextAttr();
    myTextAttr.fontName.setValue("Courier New");

    SoSeparator root = new SoSeparator();

    PoRegularMesh1D mesh1D = new PoRegularMesh1D();
    mesh1D.setGeometry(y.length, 0.5f, 9.5f);
    mesh1D.addValuesSet(0, y);

    PoCylindricalBar cylindricalBar = new PoCylindricalBar();
    cylindricalBar.radius.setValue(0.5f);

    PoGroup2Axis g2Axis = new
        PoGroup2Axis(new SbVec2f(0, 0), new SbVec2f(10, 10),
                     PoGroup2Axis.AxisTypes.LINEAR,
                     PoGroup2Axis.AxisTypes.LINEAR,
                     "X-Axis", "Y-Axis");

    SoMaterial material = new SoMaterial();
    material.diffuseColor.setValue(0.7F, 0.F, 0.F);
    material.specularColor.setValue(0.8F, 0.F, 0.F);
    material.shininess.setValue(0.4F);

    { // assemble scene graph
      root.addChild(myDomain);
      root.addChild(mesh1D);
      root.addChild(myTextAttr);
      root.addChild(g2Axis);
      root.addChild(material);
      root.addChild(cylindricalBar);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("CylindricalBar");
  }
}
