package meshviz.graph.sample.genAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.graph.PoCartesianAxis;
import com.openinventor.meshviz.graph.PoGenAxis;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private static String[] country = {"France", "Germany", "U.S.A", "Italy", "Belgium"} ;
  private static String[] town = {"Paris", "Berlin", "Chicago", "Naple", "Bruxelles"} ;

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoGenAxis genAxisX = new PoGenAxis() ;
    genAxisX.titleVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    genAxisX.titleString.setValue("X-Axis") ;
    genAxisX.gradList.setValues(0, country) ;
    genAxisX.set("bodyApp.material", "diffuseColor 1 0 0") ;

    PoGenAxis genAxisY = new PoGenAxis(new SbVec3f(0,0,0), 1, PoCartesianAxis.Types.YX, town) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(textAttr);
      root.addChild(genAxisX) ;
      root.addChild(genAxisY) ;
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Head Light");
  }
}
