package meshviz.graph.sample.itemLegend;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoItemLegend;
import com.openinventor.meshviz.graph.PoLegend;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    String[] items = {
      "Bordeaux",
      "Los Angeles",
      "Paris",
      "Madrid",
      "San Diego",
      "London",
      "Rome",
      "New York",
      "San Francisco",
      "Montreal"
    } ;
    SbColor[] colors =
    { new SbColor(1, 0, 0), new SbColor(0, 1, 0), new SbColor(0, 0, 1),
      new SbColor(0, 1, 1), new SbColor(1, 0, 1), new SbColor(1, 1, 0),
      new SbColor(0.5F, 0.5F, 0.5F), new SbColor(1, 1, 1), new SbColor(0.2F, 0.4F, 0.8F),
      new SbColor(0.7F, 0.6F, 0.3F) } ;

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoItemLegend legend = new PoItemLegend(new SbVec2f(0,0), new SbVec2f(0.5F, 1), items) ;
    legend.titleString.setValue("Cities") ;
    legend.titleFontSize.setValue(0.075F) ;
    legend.titleVisibility.setValue(PoLegend.Visibilities.VISIBILITY_ON) ;
    legend.boxColor.setValues(0, colors) ;
    legend.boxRatio.setValue(2) ;
    legend.incrementType.setValue(PoLegend.IncrementTypes.VERTICAL_INCREMENT) ;

    legend.set("backgroundApp.material", "diffuseColor 0 0 0") ;
    legend.set("backgroundBorderApp.material", "diffuseColor 1 0 0") ;

    SoAnnotation root = new SoAnnotation() ;
    { // assemble scene graph
      root.addChild(textAttr);
      root.addChild(legend);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Item Legend");
  }
}
