package meshviz.graph.sample.linearAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.graph.PoCartesianAxis.Types;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoDomain domain = new PoDomain();
    domain.min.setValue(50, 5, 0);
    domain.max.setValue(100, 10,1);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoLinearAxis linAxisX = new PoLinearAxis() ;
    linAxisX.titleVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    linAxisX.titleString.setValue("X-Axis") ;
    linAxisX.start.setValue(50, 5, 0) ;
    linAxisX.end.setValue(100) ;
    linAxisX.tickSubDef.setValue(PoAxis.TickSubDefs.NUM_SUB_TICK) ;
    linAxisX.tickNumOrPeriod.setValue((short)1) ;

    PoLinearAxis linAxisY = new PoLinearAxis(new SbVec3f(50,5,0), 10, Types.YX, 0) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(linAxisX) ;
      root.addChild(linAxisY);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Linear Axis");
  }
}
