package meshviz.graph.sample.logAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.graph.PoCartesianAxis.Types;
import com.openinventor.meshviz.graph.PoLogAxis;
import com.openinventor.meshviz.graph.PoLogAxis.DecadeListDefs;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(3,3,3);

    short[] decGradList =
    {(short)2,(short)3,(short)4,(short)5,(short)6,(short)7,(short)8,(short)9} ;

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoLogAxis logAxisX = new PoLogAxis() ;
    logAxisX.titleVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    logAxisX.titleString.setValue("X-Axis") ;
    logAxisX.tenPowerRep.setValue(PoLogAxis.TenPowGradReps.TEN_POWER_POW10) ;
    logAxisX.decadeRep.setValue(PoLogAxis.DecadeReps.DECADE_DIGIT) ;
    logAxisX.gradPath.setValue(PoAxis.TextPaths.PATH_RIGHT) ;
    logAxisX.gradPosition.setValue(PoAxis.GradPositions.GRAD_BELOW) ;
    logAxisX.end.setValue(3) ;
    logAxisX.titlePosition.setValue(PoAxis.TitlePositions.TITLE_END) ;
    logAxisX.set("bodyApp.material", "diffuseColor 1 0 0") ;

    PoLogAxis logAxisY = new PoLogAxis(new SbVec3f(0,0,0), 3, Types.YX,
				       DecadeListDefs.DECADE_LIST_NON_AUTO, decGradList) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(logAxisX) ;
      root.addChild(logAxisY);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Log Axis");
  }
}
