package meshviz.graph.sample.nonLinearValueLegend2;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoLegend;
import com.openinventor.meshviz.graph.PoNonLinearValueLegend2;
import com.openinventor.meshviz.nodes.PoIsovaluesList;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;
import com.openinventor.meshviz.nodes.PoNonLinearDataMapping2;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    float[] values = {0, 0.0025F, 0.005F, 0.0075F, 0.0100F} ;
    SbColor[] colors = { new SbColor(0,0,1), new SbColor(0,1,1), new SbColor(0,1,0),
			 new SbColor(1,1,0), new SbColor(1,0,0)} ;

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoNonLinearDataMapping2 dataMapping = new PoNonLinearDataMapping2() ;
    dataMapping.type.setValue(PoNonLinearDataMapping2.Types.LINEAR_PER_LEVEL);
    dataMapping.color.setValues(0,colors);
    dataMapping.value.setValues(0,values);
    dataMapping.minThreshold.setValue(-10e5F);
    dataMapping.minThresholdColor.setValue(new SbColor(0.5F, 0.5F, 0.5F));
    dataMapping.minThresholdEnabled.setValue(true);
    dataMapping.maxThreshold.setValue(10e5F);
    dataMapping.maxThresholdColor.setValue(new SbColor(0.5F, 0.5F, 0.5F));
    dataMapping.maxThresholdEnabled.setValue(true);

    PoIsovaluesList isoValues = new PoIsovaluesList() ;
    isoValues.setRegularIsoList(21, 0, 0.0005F) ;

    PoNonLinearValueLegend2 legend =
      new PoNonLinearValueLegend2(new SbVec2f(0,0), new SbVec2f(0.5F, 1)) ;

    legend.numColumns.setValue((short)2) ;
    legend.titleString.setValue("Pressure") ;
    legend.titleFontSize.setValue(0.075F) ;
    legend.titleVisibility.setValue(PoLegend.Visibilities.VISIBILITY_ON) ;
    legend.boxRatio.setValue(2) ;
    legend.incrementType.setValue(PoLegend.IncrementTypes.VERTICAL_INCREMENT) ;

    legend.set("backgroundApp.material", "diffuseColor 0 0 0") ;
    legend.set("backgroundBorderApp.material", "diffuseColor 1 0 0") ;

    SoAnnotation root = new SoAnnotation() ;
    { // assemble scene graph
      root.addChild(textAttr);
      root.addChild(dataMapping);
      root.addChild(isoValues);
      root.addChild(legend);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Non Linear Value Legend 2");
  }
}
