package meshviz.graph.sample.polarLinAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.graph.PoPolarLinAxis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoDomain domain = new PoDomain();
    domain.min.setValue(-5, -5, 0);
    domain.max.setValue(5, 5,0);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoPolarLinAxis polLinAxis = new PoPolarLinAxis(-5,5,10,0.75F) ;
    polLinAxis.titleVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    polLinAxis.titlePosition.setValue(PoAxis.TitlePositions.TITLE_END) ;
    polLinAxis.titleString.setValue("X-Axis") ;
    polLinAxis.gridVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    polLinAxis.gridLengthGradSide.setValue(2.3F) ;
    polLinAxis.gridLengthGradOtherSide.setValue(1.5F) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(polLinAxis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Polar Linear Axis");
  }
}
