package meshviz.graph.sample.polarLogAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.graph.PoPolarLogAxis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoDomain domain = new PoDomain();
    domain.min.setValue(-2, -2, 0);
    domain.max.setValue(2, 2,0);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoPolarLogAxis polLogAxis = new PoPolarLogAxis(0,0,2,0.75F) ;
    polLogAxis.titleVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    polLogAxis.titlePosition.setValue(PoAxis.TitlePositions.TITLE_END) ;
    polLogAxis.titleString.setValue("X-Axis") ;
    polLogAxis.gridVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    polLogAxis.gridLengthGradSide.setValue(2.3F) ;
    polLogAxis.gridLengthGradOtherSide.setValue(1.5F) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(polLogAxis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Polar Log Axis");
  }
}
