package meshviz.graph.sample.tube;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCartesianAxis;
import com.openinventor.meshviz.graph.PoChart;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.graph.PoTube;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoEllipticProfile;
import com.openinventor.meshviz.nodes.PoIrregularMesh1D;
import com.openinventor.meshviz.nodes.PoMesh1DHints;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/*----------------------------------------------------------------------------*/

public class Main extends Example
{
  private IViewerExaminer myViewer;

  @Override
  public void start() {
    float x[] = {0.5F, 1.5F, 1.8F, 2.4F, 3.2F, 4.5F, 6.3F, 6.9F, 8.0F, 8.5F, 9.0F,
                 9.5F, 9.8F, 10.F} ;
    float y[] = {9.0F, 7.0F, 6.5F, 6.0F, 5.0F, 5.5F, 6.0F, 7.7F, 6.8F, 6.0F, 5.5F,
                 4.5F, 3.5F, 2.5F}  ;
    float size[] = {1, 3, 5, 1, 3, 5, 1, 3, 5, 1, 3, 5, 1, 3} ;

    SbColor colorListD[] = {
      new SbColor(1,0,0), new SbColor(0, 1, 0), new SbColor(0, 0, 1)
    } ;

    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoDomain myDomain = new PoDomain() ;
    myDomain.min.setValue(0, 0, -1) ;
    myDomain.max.setValue(10, 10, 1) ;

    PoMiscTextAttr myTextAttr = new PoMiscTextAttr() ;
    myTextAttr.fontName.setValue("Courier New");

    SoSeparator root = new SoSeparator() ;

    PoIrregularMesh1D mesh1D = new PoIrregularMesh1D() ;
    mesh1D.setGeometry(x.length, x) ;
    mesh1D.addValuesSet(0, y) ;
    mesh1D.addValuesSet(1, size) ;

    PoMesh1DHints mesh1DHints = new PoMesh1DHints() ;
    mesh1DHints.geomInterpretation.setValue(PoMesh1DHints.GeomInterpretations.SMOOTH);

    SoMaterial mat = new SoMaterial() ;
    mat.diffuseColor.setValues(0, colorListD) ;

    PoEllipticProfile profile = new PoEllipticProfile() ;
    profile.xRadius.setValue(0.15F );
    profile.yRadius.setValue(0.025F );

    PoTube tube = new PoTube() ;
    tube.material.setValue(mat) ;
    tube.colorBinding.setValue(PoChart.ColorBindings.PER_VERTEX );
    tube.thicknessFactor.setValue(0.5f );
    tube.thicknessIndex.setValue(1 );

    PoGroup2Axis g2Axis = new
      PoGroup2Axis(new SbVec2f(0,0), new SbVec2f(10, 10),
                   PoGroup2Axis.AxisTypes.LINEAR,
                   PoGroup2Axis.AxisTypes.LINEAR,
                   "X-Axis", "Y-Axis") ;
    PoLinearAxis zAxis = new PoLinearAxis(new SbVec3f(0,0,-1), 1, PoCartesianAxis.Types.ZY) ;

    { // assemble scene graph
      root.addChild(mesh1D);
      root.addChild(myDomain);
      root.addChild(myTextAttr);
      root.addChild(mesh1DHints);
      root.addChild(profile);
      root.addChild(tube);
      root.addChild(zAxis);
      root.addChild(g2Axis);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Tube");
  }
}/*---------------------------------------------------------------------------*/
