package meshviz.graph.sample.valuedMarkerField;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoValuedMarkerField;
import com.openinventor.meshviz.nodes.PoLinearDataMapping;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    float[] sizes = {100, 300, 500, 600, 900, 800, 700, 300, 400, 200} ;
    float[] values = {1.2665F, 3.45F, 7.5F, 8.99F, 12, 11.55F, 9.3F, 3.31416F, 5.5F, 2} ;
    SbVec2f[] points = { new SbVec2f(1,1), new SbVec2f(2,2), new SbVec2f(3,3),
			 new SbVec2f(4,4), new SbVec2f(5,5), new SbVec2f(6,6),
			 new SbVec2f(7,7), new SbVec2f(8,8), new SbVec2f(9,9),
			 new SbVec2f(9.5F,10)} ;
    PoLinearDataMapping dataMapping = new PoLinearDataMapping() ;
    dataMapping.color1.setValue(new SbColor(1,0,0));
    dataMapping.color2.setValue(new SbColor(0,0,1));
    dataMapping.value1.setValue(1);
    dataMapping.value2.setValue(12);

    PoValuedMarkerField valMkFld = new PoValuedMarkerField(points, values, sizes) ;

    SoSeparator root = new SoSeparator() ;
    root.addChild(dataMapping);
    root.addChild(valMkFld) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Valued Marker Field");
  }
}
