package meshviz.mesh.advanced.RegularGrid3D;

import java.awt.BorderLayout;

import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoRegularCartesianGrid3D;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private static final int NUM_DATASET = 15;
  private static final int NUM_X = 30;
  private static final int NUM_Y = 30;
  private static final int NUM_Z = 30;
  private float v[][];
  private MeshViewer m_meshViewer;

  public Main() {
    v = new float[NUM_DATASET][NUM_X*NUM_Y*NUM_Z];
  }

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("PbRegularCartesianGrid3D");
  }

  @Override
  public void start() {
    String []data_names = {
        "F1  = X*X + Y*Y + Z*Z                  ",
        "F2  = X*X + Y + Z*Z*Z                  ",
        "F3  = X*X + 5Y + Z*Z                   ",
        "F4  = X*X + Y*Y*Y + Z*Z*Z*Z            ",
        "F5  = X*X*Y + Z                        ",
        "F6  = X*X*Y*Y + Z*X                    ",
        "F7  = X*Y*Z                            ",
        "F8  = CosX + SinY + SinZ*SinZ          ",
        "F9  = CosX + CosY + SinZ               ",
        "F10 = CosX * CosY * SinZ               ",
        "F11 = CosX*CosX  + SinY*SinY           ",
        "F12 = CosX*CosX + SinY*SinY + CosZ*CosZ",
        "F13 = XCosX  + YSinY + CosZ*CosZ       ",
        "F14 = XCosX  + YSinY + ZCosZ           ",
        "F15 = X*X*X + Y*Y*Y + Z*Z*Z -2X*Y*Z    "
    };

    compute_data( -2, -2, -2, 2, 2, 2);

    PoRegularCartesianGrid3D mesh = new PoRegularCartesianGrid3D();
    mesh.setGeometry(NUM_X, NUM_Y, NUM_Z, -2, -2, -2, 2, 2, 2);
    for (int i = 0; i < NUM_DATASET; i++)
      mesh.addValuesSet(i, v[i], data_names[i]);

    m_meshViewer = new MeshViewer();
    final IViewerExaminer viewer = m_meshViewer.show(mesh);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private void compute_data(float xmin, float ymin, float zmin,
                            float xmax, float ymax, float zmax) {
    float[] x = new float[NUM_X];
    float[] y = new float[NUM_Y];
    float[] z = new float[NUM_Z];
    float xc, yc, zc;
    int i, j, k;

    for (i = 0; i < NUM_X; i++)
      x[i] = xmin + i * (xmax - xmin) / (NUM_X - 1);
    for (i = 0; i < NUM_Y; i++)
      y[i] = ymin + i * (ymax - ymin) / (NUM_Y - 1);
    for (i = 0; i < NUM_Z; i++)
      z[i] = zmin + i * (zmax - zmin) / (NUM_Z - 1);

    for (i = 0; i < NUM_X; i++) {
      xc = x[i] * x[i];
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j] * y[j];
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k] * z[k];
          v[0][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i] * x[i];
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j];
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k] * z[k] * z[k];
          v[1][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i] * x[i];
      for (j = 0; j < NUM_Y; j++) {
        yc = 5 * y[j];
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k] * z[k];
          v[2][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i] * x[i];
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j] * y[j] * y[j];
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k] * z[k];
          v[3][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc * zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i] * x[i];
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j];
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k];
          v[4][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc * yc + zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i] * x[i];
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j] * y[j];
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k];
          v[5][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc * yc + zc * x[i];
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i];
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j];
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k];
          v[6][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc * yc * zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = (float)Math.cos(x[i]);
      for (j = 0; j < NUM_Y; j++) {
        yc = (float)Math.sin(y[j]);
        for (k = 0; k < NUM_Z; k++) {
          zc = (float)Math.sin(z[k]);
          v[7][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc * zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = (float)Math.cos(x[i]);
      for (j = 0; j < NUM_Y; j++) {
        yc = (float)Math.cos(y[j]);
        for (k = 0; k < NUM_Z; k++) {
          zc = (float)Math.sin(z[k]);
          v[8][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = (float)Math.cos(x[i]);
      for (j = 0; j < NUM_Y; j++) {
        yc = (float)Math.cos(y[j]);
        for (k = 0; k < NUM_Z; k++) {
          zc = (float)Math.sin(z[k]);
          v[9][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc * yc * zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = (float)Math.cos(x[i]);
      xc = xc * xc;
      for (j = 0; j < NUM_Y; j++) {
        yc = (float)Math.sin(y[j]);
        yc = yc * yc;
        for (k = 0; k < NUM_Z; k++) {
          v[10][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = (float)Math.cos(x[i]);
      xc = xc * xc;
      for (j = 0; j < NUM_Y; j++) {
        yc = (float)Math.sin(y[j]);
        yc = yc * yc;
        for (k = 0; k < NUM_Z; k++) {
          zc = (float)Math.cos(z[k]);
          v[11][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc * zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i];
      xc = xc * (float)Math.cos(xc);
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j];
        yc = yc * (float)Math.sin(yc);
        for (k = 0; k < NUM_Z; k++) {
          zc = (float)Math.cos(z[k]);
          v[12][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc * zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i];
      xc = xc * (float)Math.cos(xc);
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j];
        yc = yc * (float)Math.sin(yc);
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k] * (float)Math.cos(z[k]);
          v[13][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc;
        }
      }
    }

    for (i = 0; i < NUM_X; i++) {
      xc = x[i];
      for (j = 0; j < NUM_Y; j++) {
        yc = y[j];
        for (k = 0; k < NUM_Z; k++) {
          zc = z[k];
          v[14][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc * xc * xc +
              yc * yc * yc +
              zc * zc * zc -
              2.f * xc * yc * zc;
        }
      }
    }
  }
}
