package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.meshviz.data.PbMesh;
import com.openinventor.meshviz.nodes.PoDomain;

public class AltitudeNode extends RepresentNode {
  private String m_name;
  private AltitudePanel m_panel;
  private Mesh2DNode m_parent;
  private PoDomain m_domain;
  public PbMesh m_mesh;
  public String[] m_datasetNames;

  public AltitudeNode(PbMesh mesh, PoDomain domain, String[] dataset_names) {
    m_name = "Altitude";
    m_mesh = mesh;
    m_domain = domain;
    m_datasetNames = dataset_names;

    m_panel = new AltitudePanel(this);
    setDatasetUsed((short)m_panel.m_datasetUsed.getSelectedIndex());
  }

  public void setDatasetUsed(short which_zDataset) {
    Scalar2DRepresentNode.m_zDatasetIndex = which_zDataset;

    // set zValuesIndex for each visible representation
    for (int i = 0; i < Scalar2DRepresentNode.m_poMesh2DNodes.size(); i++) {
      Scalar2DRepresentNode node =
          (Scalar2DRepresentNode)Scalar2DRepresentNode.m_poMesh2DNodes.get(i);
      node.updateZDatasetIndex();
    }

    if ( which_zDataset > -1 && m_domain != null )
    {
      // the domain is set to the smallest cube, including the
      // 3D mesh representation
      float zmin = m_mesh.getMinValuesSet(Scalar2DRepresentNode.m_zDatasetIndex);
      float zmax = m_mesh.getMaxValuesSet(Scalar2DRepresentNode.m_zDatasetIndex);
      SbVec3f min = m_domain.min.getValue();
      min.setZ(zmin);
      SbVec3f max = m_domain.max.getValue();
      max.setZ(zmax);
      m_domain.setValues(min, max, PoDomain.BoundingBoxTypes.MIN_BOUNDING_CUBE);
    }
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = (Mesh2DNode)parent;
    return null;
  }

  public SoNode[] delete(boolean is_drop_action) {
    setDatasetUsed((short)-1);
    return null;
  }

  public void show(boolean show) {
    if (show)
      setDatasetUsed((short)m_panel.m_datasetUsed.getSelectedIndex());
    else
      setDatasetUsed((short)-1);
  }

  public void setPickable(boolean pickable) {}

  public DataNode getDataNodeParent() {
    return m_parent;
  }
}
