package meshviz.mesh.advanced.meshViewer;

import java.util.Vector;

import com.openinventor.inventor.nodes.SoPolygonOffset;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.meshviz.data.PoMesh;

public class Mesh3DNode extends MeshNode {
  private String m_name;
  private Vector<?> m_vectorFields;
  public int m_levelSurfIndex;

  public Mesh3DNode(SoSeparator scene3D) {
    m_name = "Mesh 3D";
    m_vectorFields = new Vector<>();
    m_levelSurfIndex = 0;

    m_meshSep = new SoSeparator();
    m_meshSep.addChild(new SoPolygonOffset());

    scene3D.addChild(m_meshSep);
  }

  // Scalar 3D
  public void addCutPlane(MeshCutPlaneNode cp_node) {
    cp_node.m_meshCrossSection.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    cp_node.m_meshCrossContour.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    m_meshSep.insertChild(cp_node.m_meshCutPlaneSwitch, 0);
  }

  public void removeCutPlane(MeshCutPlaneNode cp_node) {
    m_meshSep.removeChild(cp_node.m_meshCutPlaneSwitch);
  }

  public void addMeshSkin(MeshSkinNode ms_node) {
    ms_node.m_meshSkin.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    m_meshSep.addChild(ms_node.m_meshSkinSep);
  }

  public void removeMeshSkin(MeshSkinNode ms_node) {
    m_meshSep.removeChild(ms_node.m_meshSkinSep);
  }

  public void addMeshLevelSurf(MeshLevelSurfNode mls_node){
    mls_node.m_meshLevelSurf.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    m_meshSep.addChild(mls_node.m_meshLevelSurfSwitch);
    m_levelSurfIndex++;
  }

  public void removeMeshLevelSurf(MeshLevelSurfNode mls_node){
    m_meshSep.removeChild(mls_node.m_meshLevelSurfSwitch);
    m_levelSurfIndex--;
  }

  // Skeleton
  public void addMeshSkeleton(MeshSkeletonNode msk_node) {
    m_meshSep.addChild(msk_node.m_meshSkeletonSep);
  }

  public void removeMeshSkeleton(MeshSkeletonNode ms_node) {
    m_meshSep.removeChild(ms_node.m_meshSkeletonSep);
  }

  public String toString() {
    return m_name;
  }

  public Vector<?> getVectorFields() {
    return m_vectorFields;
  }
}
