package meshviz.mesh.advanced.meshViewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.SbPlane;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class MeshCutPlanePanel extends RepresentNodePanel {
  private final String[] CUTPLANE_BOX_ITEMS = {
      "Cross section", "Cross Contour", "Both"
  };
  private final String[] ORIENT_BOX_ITEMS = {
      "X", "Y", "Z"
  };

  private MeshCutPlaneNode m_node;

  JComboBox<String> m_meshCutPlane;
  JComboBox<String> m_cutPlaneOrient;
  JCheckBox m_clippingOn;
  JCheckBox m_frontSide;

  public MeshCutPlanePanel(MeshCutPlaneNode node) {
    super(node, node.toString(), true, true);
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/MeshCutPlaneHelp.htm");
      m_helpPage = help_file.toURI().toURL();
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Cut plane visibility");

    m_transparencySlider.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.setTransparency(value);
      }
    });

    m_coloringModeBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = m_coloringModeBox.getSelectedIndex();
        m_node.m_meshCrossSection.coloringType.setValue(selected_index);
        m_node.m_meshCrossContour.coloringType.setValue(selected_index);
        m_node.m_whichColoringType = selected_index;
      }
    });
    m_coloringModeBox.setSelectedIndex(2);

    // Cut plane
    m_meshCutPlane = new JComboBox<String>(CUTPLANE_BOX_ITEMS);
    m_meshCutPlane.setSelectedIndex(2);
    m_meshCutPlane.addActionListener(new MeshCutPlaneListener());
    JLabel cut_plane_label = new JLabel("Mesh Cut Plane");

    // Orientation
    JLabel orient_label = new JLabel("Orientation");
    m_cutPlaneOrient = new JComboBox<String>(ORIENT_BOX_ITEMS);
    m_cutPlaneOrient.setSelectedIndex(2);
    m_cutPlaneOrient.addActionListener(new CutPlaneOrientListener());

     // Rotate dragger
    JCheckBox rotate_dragger = new JCheckBox("Rotate");
    rotate_dragger.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED)
          m_node.m_cutPlaneRotateDraggerSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_node.m_cutPlaneRotateDraggerSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    // Clipping
    m_clippingOn = new JCheckBox("On");
    m_clippingOn.addItemListener(new ClippingListener());
    JLabel side_label = new JLabel("Side");
    m_frontSide = new JCheckBox("Front");
    m_frontSide.addItemListener(new FrontClippingListener());
    JCheckBox back_side = new JCheckBox("Back");
    back_side.setSelected(true);
    ButtonGroup bg = new ButtonGroup();
    bg.add(m_frontSide);
    bg.add(back_side);

    SpringLayout sp_layout = new SpringLayout();
    JPanel clipping_panel = new JPanel(sp_layout);
    TitledBorder tb = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                        "Clipping");
    tb.setTitleJustification(TitledBorder.LEFT);
    clipping_panel.setBorder(tb);
    clipping_panel.add(m_clippingOn);
    clipping_panel.add(side_label);
    clipping_panel.add(m_frontSide);
    clipping_panel.add(back_side);
    sp_layout.putConstraint(SpringLayout.NORTH, m_clippingOn, NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, clipping_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, side_label,
                            NORTH_INNER_PANEL_CONSTRAINT+4,
                            SpringLayout.NORTH, clipping_panel);
    sp_layout.putConstraint(SpringLayout.WEST, side_label, 49,
                            SpringLayout.EAST, m_clippingOn);
    sp_layout.putConstraint(SpringLayout.NORTH, m_frontSide, NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, clipping_panel);
    sp_layout.putConstraint(SpringLayout.WEST, m_frontSide, 15,
                            SpringLayout.EAST, side_label);
    sp_layout.putConstraint(SpringLayout.NORTH, back_side, NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, clipping_panel);
    sp_layout.putConstraint(SpringLayout.WEST, back_side, 5,
                            SpringLayout.EAST, m_frontSide);
    sp_layout.putConstraint(SpringLayout.EAST, clipping_panel, 198,
                            SpringLayout.EAST, back_side);
    sp_layout.putConstraint(SpringLayout.SOUTH, clipping_panel, SOUTH_CONSTRAINT,
                            SpringLayout.SOUTH, m_clippingOn);

    // Main panel
    add(cut_plane_label);
    add(m_meshCutPlane);
    add(orient_label);
    add(m_cutPlaneOrient);
    add(rotate_dragger);
    add(clipping_panel);
    m_spLayout.putConstraint(SpringLayout.WEST, cut_plane_label, 10,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, cut_plane_label, 33,
                             SpringLayout.SOUTH, m_coloringModeBox);
    m_spLayout.putConstraint(SpringLayout.NORTH, m_meshCutPlane, 30,
                             SpringLayout.SOUTH, m_coloringModeBox);
    m_spLayout.putConstraint(SpringLayout.WEST, m_meshCutPlane, 6,
                             SpringLayout.EAST, cut_plane_label);

    m_spLayout.putConstraint(SpringLayout.NORTH, orient_label, 18,
                             SpringLayout.SOUTH, m_meshCutPlane);
    m_spLayout.putConstraint(SpringLayout.WEST, orient_label, 10,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, m_cutPlaneOrient, 15,
                             SpringLayout.SOUTH, m_meshCutPlane);
    m_spLayout.putConstraint(SpringLayout.WEST, m_cutPlaneOrient, 31,
                             SpringLayout.EAST, orient_label);
    m_spLayout.putConstraint(SpringLayout.NORTH, rotate_dragger, 15,
                             SpringLayout.SOUTH, m_meshCutPlane);
    m_spLayout.putConstraint(SpringLayout.WEST, rotate_dragger, 12,
                             SpringLayout.EAST, m_cutPlaneOrient);
    m_spLayout.putConstraint(SpringLayout.NORTH, clipping_panel, 10,
                             SpringLayout.SOUTH, rotate_dragger);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, clipping_panel);
  }

  class MeshCutPlaneListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = m_meshCutPlane.getSelectedIndex();
      switch (selected_index) {
        case 0:
          m_node.m_meshCrossSectionSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_ALL);
          m_node.m_meshCrossContourSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_NONE);
          break;
        case 1:
          m_node.m_meshCrossSectionSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_NONE);
          m_node.m_meshCrossContourSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_ALL);
          break;
        case 2:
          m_node.m_meshCrossSectionSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_ALL);
          m_node.m_meshCrossContourSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_ALL);
          break;
      }
    }
  }

  class CutPlaneOrientListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = m_cutPlaneOrient.getSelectedIndex();
      m_node.updateDraggers(selected_index);
    }
  }


  class ClippingListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_node.m_clipPlane.on.setValue(true);
      else
        m_node.m_clipPlane.on.setValue(false);
    }
  }

  class FrontClippingListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      SbPlane old_plane = m_node.m_clipPlane.plane.getValue();
      SbVec3f clip_normal = old_plane.getNormal();
      clip_normal.negate();
      m_node.m_clipPlane.plane.setValue(new SbPlane(clip_normal,
                                                    -old_plane.getDistanceFromOrigin()));
    }
  }
}
