package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.*;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.draggers.*;
import com.openinventor.inventor.events.*;
import com.openinventor.inventor.misc.callbacks.*;
import com.openinventor.meshviz.nodes.*;
import com.openinventor.meshviz.data.PoMeshProbePoint;
import com.openinventor.meshviz.data.*;
import com.openinventor.meshviz.misc.callbacks.*;

public class MeshProbeNode extends ScalarRepresentNode {
  PoCellFacets m_cellFacets;
  PoCellIndices m_cellIndices;
  PoCellEdges m_cellEdges;
  PoMeshProbePoint m_meshProbePoint;
  SoCoordinate3 m_pickedPointCoord;
  SoMarkerSet m_pickedPoint;
  SoJackDragger m_probeDragger;
  SoSwitch m_probeDraggerSwitch;
  SoEventCallback m_eventCallback;
  MouseMovedCallback m_mouseMovedCB;
  SoSwitch m_cellFacetsSwitch;
  SoSwitch m_cellEdgesSwitch;
  SoSwitch m_cellIndicesSwitch;
  SoSwitch m_pickedPointSwitch;
  SoSwitch m_meshProbeSwitch;
  SoSeparator m_meshProbeSep;

  private SoNode[] m_inventorNodes;
  private PoMeshProperty m_meshNode;
  private SoText2 m_cellIndexText;
  private SoText2 m_probeValueText;
  private SoTranslation m_trans1;
  private SoSwitch m_textSwitch;
  private SoGroup m_textGroup;
  private SoSwitch m_probeTextInfoSwitch;
  private String m_name;
  private int m_number;
  private MeshProbePanel m_panel;
  private DataNode m_parent;
  public float m_scaleFactor;

  public MeshProbeNode(PoMeshProperty mesh_node, SbBox3f bbox,
                       SoSwitch probe_text_info_switch) {
    m_number = m_probeVector.size() + 1;
    m_name = "Mesh Probe " + m_number;
    m_meshNode = mesh_node;
    m_probeTextInfoSwitch = probe_text_info_switch;

    { // dragger

      SbVec3f bounding_box_center = bbox.getCenter();
      float[] bbox_size = bbox.getSize().array;
      float maxs = bbox_size[0];
      if (bbox_size[1] > maxs)
        maxs = bbox_size[1];
      if (bbox_size[2] > maxs)
        maxs = bbox_size[2];

      m_scaleFactor = maxs / 10;
      m_probeDragger = new SoJackDragger();
      m_probeDragger.scaleFactor.setValue(m_scaleFactor, m_scaleFactor,
                                          m_scaleFactor);
      m_probeDragger.translation.setValue(bounding_box_center);
      m_probeDragger.rotation.setValue(new SbVec3f(1, 0, 0),
                                       (float) java.lang.Math.PI / 2.f);

      m_probeDraggerSwitch = new SoSwitch();
      m_probeDraggerSwitch.addChild(m_probeDragger);
      m_probeDraggerSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }

    { // define a point-probe to visualize a cell
      m_meshProbePoint = new PoMeshProbePoint();
      m_meshProbePoint.position.connectFrom(m_probeDragger.translation);
      m_meshProbePoint.setChangeCellCallback(new ChangeCellProbeCB(), null);
      m_meshProbePoint.setMotionCallback(new MotionProbeCB(), null);
      m_meshProbePoint.setEnterMeshCallback(new EnterProbeCB(), null);
      m_meshProbePoint.setLeaveMeshCallback(new LeaveProbeCB(), null);
    }

    { // define a cell to draw, it is defined by the position of the probe
      m_cellFacets = new PoCellFacets();
      m_cellFacetsSwitch = new SoSwitch();
      m_cellFacetsSwitch.addChild(m_cellFacets);
      m_cellFacetsSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }

    { // cell edges
      m_cellEdges = new PoCellEdges();
      m_cellEdges.cellIndex.connectFrom(m_cellFacets.cellIndex);

      m_cellEdgesSwitch = new SoSwitch();
      SoDrawStyle ds = new SoDrawStyle();
      ds.lineWidth.setValue(3.0f);
      m_cellEdgesSwitch.addChild(ds);
      m_cellEdgesSwitch.addChild(m_cellEdges);
      m_cellEdgesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }

    { // cell indices
      m_cellIndices = new PoCellIndices();
      m_cellIndices.cellIndex.connectFrom(m_cellFacets.cellIndex);

      SoGroup group_cell_indices = new SoGroup();
      group_cell_indices.addChild(mesh_node);
      group_cell_indices.addChild(m_cellIndices);

      SoLevelOfDetail cell_indices_detail = new SoLevelOfDetail();
      cell_indices_detail.screenArea.setValue(2000.f);
      SoGroup empty_group = new SoGroup();
      cell_indices_detail.addChild(group_cell_indices);
      cell_indices_detail.addChild(empty_group);

      m_cellIndicesSwitch = new SoSwitch();
      m_cellIndicesSwitch.addChild(cell_indices_detail);
      m_cellIndicesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }

    { // annotation
      SoAnnotation group_picked_point = new SoAnnotation();
      SoBaseColor base_color = new SoBaseColor();
      base_color.rgb.setValue(1, 1, 1);
      m_pickedPointCoord = new SoCoordinate3();
      m_pickedPoint = new SoMarkerSet();
      group_picked_point.addChild(base_color);
      group_picked_point.addChild(m_pickedPointCoord);
      group_picked_point.addChild(m_pickedPoint);

      m_pickedPointSwitch = new SoSwitch();
      m_pickedPointSwitch.addChild(group_picked_point);
      m_pickedPointSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }

    m_eventCallback = new SoEventCallback();
    {
      m_meshProbeSwitch = new SoSwitch();
      m_meshProbeSwitch.addChild(m_probeDraggerSwitch);
      m_meshProbeSwitch.addChild(m_eventCallback);
      m_meshProbeSwitch.addChild(m_pickSwitch);
      m_meshProbeSwitch.addChild(m_meshProbePoint);
      m_meshProbeSwitch.addChild(m_cellFacetsSwitch);
      m_meshProbeSwitch.addChild(m_cellEdgesSwitch);
      m_meshProbeSwitch.addChild(m_cellIndicesSwitch);
      m_meshProbeSwitch.addChild(m_pickedPointSwitch);
      m_meshProbeSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

      m_meshProbeSep = new SoSeparator();
      m_meshProbeSep.boundingBoxCaching.setValue(SoSeparator.Cachings.OFF);
      m_meshProbeSep.addChild(m_meshProbeSwitch);
    }

    // build probe information text
    m_cellIndexText = new SoText2();
    m_cellIndexText.justification.setValue(SoText2.Justifications.LEFT);

    SoTranslation trans2 = new SoTranslation();
    trans2.translation.setValue(0.F, -0.05F, 0);
    m_probeValueText = new SoText2();
    m_probeValueText.justification.setValue(SoText2.Justifications.LEFT);

    SoGroup group_probe_text = new SoGroup();
    group_probe_text.addChild(m_cellIndexText);
    group_probe_text.addChild(trans2);
    group_probe_text.addChild(m_probeValueText);

    SoText2 text_probe_out = new SoText2();
    text_probe_out.string.setValue("probe out of mesh !");

    SoBlinker text_blinker = new SoBlinker();
    text_blinker.addChild(text_probe_out);
    text_blinker.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    m_textSwitch = new SoSwitch();
    m_textSwitch.addChild(group_probe_text);
    m_textSwitch.addChild(text_blinker);
    m_textSwitch.whichChild.setValue(0);

    m_trans1 = new SoTranslation();
    m_trans1.translation.setValue( -1.9F, 1.90F, 0);

    m_textGroup = new SoGroup();
    m_textGroup.addChild(m_trans1);
    m_textGroup.addChild(m_textSwitch);

    m_mouseMovedCB = new MouseMovedCallback();
    m_panel = new MeshProbePanel(this);

    m_inventorNodes = new SoNode[] {
        m_cellFacets, m_cellIndices, m_cellEdges,
        m_meshProbePoint, m_probeDragger
    };
  }

  public void decreaseNumber() {
    m_number--;
    m_name = "Mesh Probe " + m_number;
    m_panel.changeTitleName(m_name);
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = parent;
    if (parent instanceof MeshNode)
      ( (MeshNode) parent).addMeshProbe(this);
    else if (parent instanceof ScalarNode)
      ( (ScalarNode) parent).addMeshProbe(this);

    if (! is_drop_action) {
      m_probeTextInfoSwitch.addChild(m_textGroup);
      m_probeTextInfoSwitch.whichChild.setValue(m_number-1);

      m_probeVector.add(this);
    }

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    if (parent instanceof MeshNode)
      ( (MeshNode) parent).removeMeshProbe(this);
    else if (parent instanceof ScalarNode)
      ( (ScalarNode) parent).removeMeshProbe(this);

    if (!is_drop_action) {
      m_probeTextInfoSwitch.removeChild(m_number-1);
      for (int i = m_number; i < m_probeVector.size(); i++)
        ( (MeshProbeNode) m_probeVector.get(i)).decreaseNumber();
      m_probeVector.remove(m_number - 1);
    }

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshProbeSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshProbeSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }

  public void connectProbeToDraggerMotion(boolean connect) {
    m_meshProbePoint.position.enableConnection(connect);
  }

  public void connectProbeToMouseMotion(boolean connect) {
    if (connect)
      m_eventCallback.addEventCallback(SoLocation2Event.class, m_mouseMovedCB);
    else
      m_eventCallback.removeEventCallback(SoLocation2Event.class,
                                          m_mouseMovedCB, null);
  }

  class MouseMovedCallback extends SoEventCallbackCB {
    public void invoke(SoEventCallback node) {
      SoPickedPoint picked_point = node.getPickedPoint();
      if (picked_point == null) {//return;
        m_meshProbePoint.position.setValue(Float.MAX_VALUE, Float.MAX_VALUE,
                                           Float.MAX_VALUE);
        m_pickedPointSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      } else {
        m_pickedPointSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        m_pickedPointCoord.point.setValue(picked_point.getPoint());
        m_meshProbePoint.position.setValue(picked_point.getPoint());
        m_meshProbePoint.tolerance.setValue(0.02f);
      }
    }
  }

  class ChangeCellProbeCB extends PoProbeCB {
    public void invoke(PoMeshProbePoint probe, PbCell cell) {
      m_meshProbeSwitch.enableNotify(false);
      if (cell == null)
        m_cellFacets.cellIndex.setValue(-1);
      else {
        m_cellFacets.cellIndex.setValue(cell.getIndex());

        String str = "cell index : " + cell.getIndex();
        m_textGroup.enableNotify(false);
        m_cellIndexText.string.setValue(str);
        m_textGroup.enableNotify(true);
      }
      m_meshProbeSwitch.enableNotify(true);
    }
  }

  class MotionProbeCB extends PoProbeCB {
    public void invoke(PoMeshProbePoint probe, PbCell cell) {
      if (cell == null)
        return;
      String str;
      int scalar_data_index = probe.valuesIndex.getValue();
      float[] scalar_data = m_meshNode.getMesh().getValuesSet(scalar_data_index);
      if (scalar_data != null) {
        SbVec3f pcoord = cell.locatePoint(probe.position.getValue(), probe.tolerance.getValue());
        float probe_value = cell.getValue(pcoord, scalar_data);
        str = "value at probe : " + probe_value;
      }
      else
        str = "no value mapped";

      m_textGroup.enableNotify(false);
      m_probeValueText.string.setValue(str);
      m_textGroup.enableNotify(true);
      m_probeTextInfoSwitch.whichChild.setValue(m_number-1);
    }
  }

  class EnterProbeCB extends PoProbeCB {
    public void invoke(PoMeshProbePoint probe, PbCell cell) {
      m_textGroup.enableNotify(false);
      m_textSwitch.whichChild.setValue(0);
      m_textGroup.enableNotify(true);
    }
  }

  class LeaveProbeCB extends PoProbeCB {
    public void invoke(PoMeshProbePoint probe, PbCell cell) {
      m_textGroup.enableNotify(false);
      m_textSwitch.whichChild.setValue(1);
      m_textGroup.enableNotify(true);
    }
  }
}
