package meshviz.mesh.advanced.meshViewer;

import javax.swing.*;
import javax.swing.tree.*;
import java.awt.event.*;

public class MeshViewerPopupMenus {
  private MeshViewTree m_tree;

  // Menus
  JPopupMenu m_representMenu;
  JPopupMenu m_mesh2DMenu;
  JPopupMenu m_mesh3DMenu;
  JPopupMenu m_scalar2DMenu;
  JPopupMenu m_scalar3DMenu;
  JPopupMenu m_vector2DMenu;
  JPopupMenu m_vector3DMenu;

  public MeshViewerPopupMenus(MeshViewTree tree, boolean is_2D,
                              boolean has_vecs_set) {
    super();
    m_tree = tree;

    // create menus
    createRepresentMenu();
    if (is_2D) {
      createScalar2DMenu();
      if (has_vecs_set) {
        createVector2DMenu();
      }
      createMesh2DMenu();
    } else {
      createScalar3DMenu();
      if (has_vecs_set) {
        createVector3DMenu();
      }
      createMesh3DMenu();
    }
  }

  // Show menu
  public void show(DefaultMutableTreeNode node, int x, int y) {
    if (node instanceof Mesh2DNode) {
      m_mesh2DMenu.show(m_tree, x, y);
      return;
    }
    if (node instanceof Mesh3DNode) {
      m_mesh3DMenu.show(m_tree, x, y);
      return;
    }
    if (node instanceof Scalar2DNode) {
      m_scalar2DMenu.show(m_tree, x, y);
      return;
    }
    if (node instanceof Scalar3DNode) {
      m_scalar3DMenu.show(m_tree, x, y);
      return;
    }
    if (node instanceof Vector2DNode) {
      m_vector2DMenu.show(m_tree, x, y);
      return;
    }
    if (node instanceof Vector3DNode) {
      m_vector3DMenu.show(m_tree, x, y);
      return;
    }
    if (node instanceof RepresentNode) {
      while (m_representMenu.getComponentCount() > 3) {
        m_representMenu.remove(1);
      }

      RepresentNodePanel rep_node_panel = ((RepresentNode)node).getPanel();
      m_representMenu.insert(rep_node_panel.m_showMenuItem, 1);
      if (! (node instanceof AltitudeNode))
        m_representMenu.insert(rep_node_panel.m_pickableMenuItem, 2);

      m_representMenu.show(m_tree, x, y);
      return;
    }
  }

  private void createRepresentMenu() {
    m_representMenu = new JPopupMenu();
    m_representMenu.add(m_deleteAction);
    m_representMenu.addSeparator();
    m_representMenu.add(m_helpAction);
  }

  private void createMesh2DMenu() {
    m_mesh2DMenu = new JPopupMenu();

    m_mesh2DMenu.add(m_altitudeAction);
    m_mesh2DMenu.add(m_meshLinesAction);
    m_mesh2DMenu.add(m_meshFilledAction);
    m_mesh2DMenu.add(m_meshLimitAction);
    m_mesh2DMenu.add(m_meshSidesAction);
    m_mesh2DMenu.add(m_meshProbeAction);
  }

  private void createMesh3DMenu() {
    m_mesh3DMenu = new JPopupMenu();

    m_mesh3DMenu.add(m_skeletonAction);
    m_mesh3DMenu.add(new JPopupMenu.Separator());
    m_mesh3DMenu.add(m_cutPlaneAction);
    m_mesh3DMenu.add(m_meshSkinAction);
    m_mesh3DMenu.add(m_meshLevelSurfAction);
    m_mesh3DMenu.add(m_meshProbeAction);
  }

  private void createScalar2DMenu() {
    m_scalar2DMenu = new JPopupMenu();

    m_scalar2DMenu.add(m_meshLinesAction);
    m_scalar2DMenu.add(m_meshContouringAction);
    m_scalar2DMenu.add(m_meshFilledAction);
    m_scalar2DMenu.add(new JPopupMenu.Separator());
    m_scalar2DMenu.add(m_meshProbeAction);
  }

  private void createScalar3DMenu() {
    m_scalar3DMenu = new JPopupMenu();

    m_scalar3DMenu.add(m_cutPlaneAction);
    m_scalar3DMenu.add(m_meshSkinAction);
    m_scalar3DMenu.add(m_meshLevelSurfAction);
    m_scalar3DMenu.add(new JPopupMenu.Separator());
    m_scalar3DMenu.add(m_meshProbeAction);
  }

  private void createVector2DMenu() {
    m_vector2DMenu = new JPopupMenu();

    m_vector2DMenu.add(m_mesh2DVecFieldAction);
    m_vector2DMenu.add(m_meshStreamAction);
  }

  private void createVector3DMenu() {
    m_vector3DMenu = new JPopupMenu();

    m_vector3DMenu.add(m_mesh3DVecFieldAction);
    m_vector3DMenu.add(m_meshStreamAction);
  }

  /********* Menu Actions *********/

  /*** Represent node menu ***/
  // Delete
  Action m_deleteAction = new AbstractAction("Delete") {
    public void actionPerformed(ActionEvent e) {
      RepresentNode selected_node = (RepresentNode)
          m_tree.getLastSelectedPathComponent();
      m_tree.m_treeModel.deleteNode(selected_node, false);
      m_tree.expandAllTree();
    }
  };

  // Help
  Action m_helpAction = new AbstractAction("Help") {
    public void actionPerformed(ActionEvent e) {
      RepresentNode selected_node = (RepresentNode)
          m_tree.getLastSelectedPathComponent();
      selected_node.getPanel().m_helpButton.doClick();
    }
  };

  /*** Data node menu ***/
  // Skeleton
  Action m_skeletonAction = new AbstractAction("Add Mesh Skeleton") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node, new MeshSkeletonNode(), false);
    }
  };

  // Scalar 2D
  Action m_meshContouringAction = new AbstractAction("Add Mesh Contouring") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node,
                                   new MeshContouringNode(m_tree.m_meshViewer.m_isoValuesSwitch),
                                   false);
    }
  };

  Action m_meshLinesAction = new AbstractAction("Add Mesh Lines") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node, new MeshLinesNode(), false);
    }
  };

  Action m_meshFilledAction = new AbstractAction("Add Mesh Filled") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node, new MeshFilledNode(), false);
    }
  };

  Action m_meshLimitAction = new AbstractAction("Add Mesh Limit") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node, new MeshLimitNode(), false);
    }
  };

  Action m_meshSidesAction = new AbstractAction("Add Mesh Sides") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node,
                                   new MeshSidesNode(m_tree.m_meshViewer.m_mesh),
                                   false);
    }
  };

  Action m_altitudeAction = new AbstractAction("Add Altitude") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node,
                                   new AltitudeNode(m_tree.m_meshViewer.m_mesh,
                                                    m_tree.m_meshViewer.m_domain,
                                                    m_tree.m_datasetNames),
                                   false);
    }
  };

  // Scalar 3D
  Action m_cutPlaneAction = new AbstractAction("Add Cut Plane") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node,
                                   new MeshCutPlaneNode(m_tree.m_meshViewer.m_bbox),
                                   false);
    }
  };

  Action m_meshSkinAction = new AbstractAction("Add Mesh Skin") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node, new MeshSkinNode(), false);
    }
  };

  Action m_meshLevelSurfAction = new AbstractAction("Add Mesh Level Surface") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node,
                                   new MeshLevelSurfNode(m_tree.m_meshViewer.m_isoValuesSwitch,
            m_tree.m_datasetNames), false);
    }
  };

  Action m_meshProbeAction = new AbstractAction("Add Mesh Probe") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node,
                                   new MeshProbeNode(m_tree.m_meshViewer.m_meshNode,
                                                     m_tree.m_meshViewer.m_bbox,
                                                     m_tree.m_meshViewer.m_probeTextInfoSwitch),
                                   false);
    }
  };

  // Vector 2D
  Action m_mesh2DVecFieldAction = new AbstractAction("Add Mesh Vector Field") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node, new Mesh2DVecFieldNode
                                   (m_tree.m_meshViewer.m_mesh,
                                    m_tree.m_meshViewer.m_bbox), false);
    }
  };

  // Vector 3D
  Action m_mesh3DVecFieldAction = new AbstractAction("Add Mesh Vector Field") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node, new Mesh3DVecFieldNode
                                   (m_tree.m_meshViewer.m_mesh,
                                    m_tree.m_meshViewer.m_bbox), false);
    }
  };

  Action m_meshStreamAction = new AbstractAction("Add Mesh Stream") {
    public void actionPerformed(ActionEvent e) {
      DataNode selected_node = (DataNode) m_tree.getLastSelectedPathComponent();
      if (selected_node != null)
        m_tree.m_treeModel.addNode(selected_node, new MeshStreamNode
                                   (m_tree.m_meshViewer.m_mesh,
                                    m_tree.m_meshViewer.m_bbox), false);
    }
  };
}
