package meshviz.mesh.advanced.meshViewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class RepresentNodePanel extends JPanel {
  private static final ImageIcon EYE_ICON =
      new ImageIcon(MeshViewer.m_filePrefix + "data/eye.jpg");
  private static final ImageIcon PICKABLE_ICON =
      new ImageIcon(MeshViewer.m_filePrefix + "data/pickable.jpg");
  private static final ImageIcon HELP_ICON =
      new ImageIcon(MeshViewer.m_filePrefix + "data/help.jpg");
  private static final ImageIcon HELP_PRESSED_ICON =
      new ImageIcon(MeshViewer.m_filePrefix + "data/helpPressed.jpg");

  private final String[] COLORING_MODE_ITEMS = {
    "Constant", "Average", "Mapping", "Contouring", "Texturing"
  };
  protected static final int NORTH_CONSTRAINT = 30;
  protected static final int NORTH_INNER_PANEL_CONSTRAINT = 5;
  protected static final int SOUTH_CONSTRAINT = 5;
  protected static final int VERT_SPACE_CONSTRAINT = 5;

  private RepresentNode m_node;
  private boolean m_transparency;
  private boolean m_coloringMode;

  protected String m_name;
  protected TitledBorder m_border;
  protected SpringLayout m_spLayout;
  protected JButton m_visibilityButton;
  protected JButton m_pickableButton;
  protected JButton m_helpButton;
  protected SliderPanel m_transparencySlider;
  protected JComboBox<String> m_coloringModeBox;
  protected URL m_helpPage;

  public JMenuItem m_showMenuItem;
  public JMenuItem m_pickableMenuItem;

  public RepresentNodePanel(RepresentNode node, String name) {
    this(node, name, false, false);
  }

  public RepresentNodePanel(RepresentNode node, String name, boolean transparency,
                            boolean coloring_mode) {
    m_node = node;
    m_name = name;
    m_transparency = transparency;
    m_coloringMode = coloring_mode;
    m_helpPage = null;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }

    // Menu items
    createMenuItems();
  }

  private void jbInit() throws Exception {
    m_border = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                m_name);
    m_border.setTitleJustification(TitledBorder.CENTER);
    setBorder(m_border);

    // visibility
    m_visibilityButton = new JButton(EYE_ICON);
    m_visibilityButton.setBorder(BorderFactory.createLoweredBevelBorder());
    m_visibilityButton.addActionListener(new VisibilityListener());

    // picking style
    m_pickableButton = new JButton(PICKABLE_ICON);
    m_pickableButton.setBorder(BorderFactory.createLoweredBevelBorder());
    m_pickableButton.setToolTipText("Set unpickable");
    m_pickableButton.addActionListener(new PickableListener());

    // help frame
    m_helpButton = new JButton(HELP_ICON);
    m_helpButton.setBorder(BorderFactory.createRaisedBevelBorder());
    m_helpButton.setToolTipText("Help");
    m_helpButton.setPressedIcon(HELP_PRESSED_ICON);
    m_helpButton.addActionListener(new HelpListener());

    // main panel
    m_spLayout = new SpringLayout();
    setLayout(m_spLayout);
    add(m_visibilityButton);
    add(m_pickableButton);
    add(m_helpButton);
    m_spLayout.putConstraint(SpringLayout.WEST, m_pickableButton, 390,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.WEST, m_visibilityButton, 1,
                             SpringLayout.EAST, m_pickableButton);
    m_spLayout.putConstraint(SpringLayout.WEST, m_helpButton, 1,
                             SpringLayout.EAST, m_visibilityButton);
    m_spLayout.putConstraint(SpringLayout.EAST, this, 1,
                             SpringLayout.EAST, m_helpButton);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, 30,
                             SpringLayout.SOUTH, m_visibilityButton);

    if (m_transparency) {
      // add transparency slider
      m_transparencySlider = new SliderPanel(0, 1.f, 0, 3);
      m_transparencySlider.addInfoText("Transparency");
      m_transparencySlider.setInfoTextSize(new Dimension(85, 20));
      m_transparencySlider.setBoxSelected(false);

      add(m_transparencySlider);
      m_spLayout.putConstraint(SpringLayout.NORTH, m_transparencySlider,
                               NORTH_CONSTRAINT,
                               SpringLayout.NORTH, this);
      m_spLayout.putConstraint(SpringLayout.WEST, m_transparencySlider, 5,
                               SpringLayout.WEST, this);
      m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                               SpringLayout.SOUTH, m_transparencySlider);
    }

    if (m_coloringMode) {
      // add coloring mode settings
      JLabel coloring_mode_label = new JLabel("Coloring Mode");
      m_coloringModeBox = new JComboBox<>(COLORING_MODE_ITEMS);

      add(coloring_mode_label);
      add(m_coloringModeBox);
      if (m_transparency) {
        m_spLayout.putConstraint(SpringLayout.NORTH, coloring_mode_label, 13,
                                 SpringLayout.SOUTH, m_transparencySlider);
        m_spLayout.putConstraint(SpringLayout.NORTH, m_coloringModeBox, 10,
                                 SpringLayout.SOUTH, m_transparencySlider);
      }
      else {
        m_spLayout.putConstraint(SpringLayout.NORTH, coloring_mode_label,
                                 NORTH_CONSTRAINT+3,
                                 SpringLayout.NORTH, this);
        m_spLayout.putConstraint(SpringLayout.NORTH, m_coloringModeBox,
                                 NORTH_CONSTRAINT,
                                 SpringLayout.NORTH, this);
      }
      m_spLayout.putConstraint(SpringLayout.WEST, coloring_mode_label, 10,
                               SpringLayout.WEST, this);
      m_spLayout.putConstraint(SpringLayout.WEST, m_coloringModeBox, 13,
                               SpringLayout.EAST, coloring_mode_label);
      m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                               SpringLayout.SOUTH, m_coloringModeBox);
    }
  }

  private void createMenuItems() {
    m_showMenuItem = new JMenuItem("Hide");
    m_showMenuItem.addMouseListener(new MouseAdapter() {
      public void mouseReleased(MouseEvent e) {
        m_visibilityButton.doClick();
      }
    });

    m_pickableMenuItem = new JMenuItem("Set unpickable");
    m_pickableMenuItem.addMouseListener(new MouseAdapter() {
      public void mouseReleased(MouseEvent e) {
        m_pickableButton.doClick();
      }
    });
  }

  public void changeTitleName(String name) {
    m_name = name;
    m_border.setTitle(m_name);
  }

  class HelpListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
        if (m_helpPage != null)
          MeshViewTreeFrame.m_helpFrame.setPage(m_helpPage);
    }
  }

  class VisibilityListener implements ActionListener {
    private boolean m_visible = true;

    public void actionPerformed(ActionEvent e) {
      if (!m_visible) {
        m_node.show(true);
        m_showMenuItem.setText("Hide");
        m_visibilityButton.setBorder(BorderFactory.createLoweredBevelBorder());
        m_visible = true;
      } else {
        m_node.show(false);
        m_showMenuItem.setText("Show");
        m_visibilityButton.setBorder(BorderFactory.createRaisedBevelBorder());
        m_visible = false;
      }
    }
  }

  class PickableListener implements ActionListener {
    private boolean m_isPickable = true;

    public void actionPerformed(ActionEvent e) {
      if (!m_isPickable) {
        m_node.setPickable(true);
        m_pickableMenuItem.setText("Set unpickable");
        m_pickableButton.setToolTipText("Set unpickable");
        m_pickableButton.setBorder(BorderFactory.createLoweredBevelBorder());
        m_isPickable = true;
      } else {
        m_node.setPickable(false);
        m_pickableMenuItem.setText("Set pickable");
        m_pickableButton.setToolTipText("Set pickable");
        m_pickableButton.setBorder(BorderFactory.createRaisedBevelBorder());
        m_isPickable = false;
      }
    }
  }
}
