package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.*;
import com.openinventor.meshviz.data.PoMesh3DVec;

public class Vector3DNode extends VectorNode {

  public Vector3DNode(MeshViewer mesh_viewer, String name, int which_dataset) {
    m_name = name;
    m_whichDataset = which_dataset;

    m_moduleDataMapping = mesh_viewer.m_moduleDataMapping;

    m_vectorSep = new SoSeparator();
    m_vectorSep.addChild(m_moduleDataMapping);

    mesh_viewer.m_scene3D.addChild(m_vectorSep);
  }

  // 3D Vector field
  public void addVecField(Mesh3DVecFieldNode vf_node) {
    vf_node.m_mesh3DVecField.vecsIndex.setValue(m_whichDataset);
    vf_node.m_mesh3DVecField.bodyColoringType.setValue(PoMesh3DVec.ArrowColoringTypes.MODULE_MAPPING_COLOR);
    m_vectorSep.addChild(vf_node.m_mesh3DVecFieldSwitch);
  }

  public void removeVecField(Mesh3DVecFieldNode vf_node) {
    m_vectorSep.removeChild(vf_node.m_mesh3DVecFieldSwitch);
  }
}
