// MeshThresholdExample2 : filling undefined cells in grey
package meshviz.mesh.mentor.meshThresholdExample2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.data.PoMesh;
import com.openinventor.meshviz.data.PoMeshFilled;
import com.openinventor.meshviz.nodes.PoLinearDataMapping;
import com.openinventor.meshviz.nodes.PoParalCartesianGrid2D;
import com.openinventor.util.AsciiStreamReader;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  float vmin, vmax, undefined_value;
  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Mesh Threshold Example 2");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    String oivjhome = SoPreferences.getValue("OIVJHOME");
    PoParalCartesianGrid2D mesh = readFiles(oivjhome + "/data/mesh/UNDEFGRID.TOPO",
        oivjhome + "/data/mesh/IDESUNI.DAT");
    if (mesh == null) return;

    // Define data mapping
    PoLinearDataMapping myDataMapping = new PoLinearDataMapping();
    myDataMapping.value1.setValue(vmin);
    myDataMapping.value2.setValue(vmax);
    myDataMapping.color1.setValue(1,0,0);
    myDataMapping.color2.setValue(0,1,1);
    myDataMapping.minThresholdEnabled.setValue(false);
    myDataMapping.maxThresholdEnabled.setValue(true);
    myDataMapping.maxThreshold.setValue(undefined_value);
    myDataMapping.maxThresholdColor.setValue(0,0,0);
    myDataMapping.maxThresholdTransparency.setValue(1);
    //    myDataMapping.transparencyEnabled.setValue(true);
    myDataMapping.transparencyValueDeletedParts.setValue(1);

    // Create the solid contour visualization node.
    PoMeshFilled myFill = new PoMeshFilled();
    myFill.valuesIndex.setValue(0);
    myFill.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoSeparator root = new SoSeparator ();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(mesh);
      root.addChild(myDataMapping);
      root.addChild(myFill);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private synchronized PoParalCartesianGrid2D readFiles(String topoFile, String dataFile) {
    float[] x,y,val;
    int numX, numY;
    PoParalCartesianGrid2D mesh = null;

    URL url_topo = getURL(topoFile);
    if (url_topo == null) return null;

    URL url_data = getURL(dataFile);
    if (url_data == null) return null;

    AsciiStreamReader stream = null;
    try {
      int i, num_val ;
      stream = new AsciiStreamReader(url_topo.openStream()) ;

      numX = stream.readNextInt ();
      numY = stream.readNextInt ();
      System.out.println("Reading " + numX + " * " + numY + " nodes");

      x = new float[numX];
      y = new float[numY];

      for (i=0 ; i<numX ; i++) x[i] = stream.readNextFloat();
      for (i=0 ; i<numY ; i++) y[i] = stream.readNextFloat();

      System.out.println("End reading mesh geometry.") ;

      stream = new AsciiStreamReader(url_data.openStream());

      num_val = numX * numY;
      val = new float[num_val] ;

      vmin = 1.E30F;
      vmax = -1.E30F;

      for(i=0 ; i< num_val ; i++) {
        val[i] = stream.readNextFloat ();
        if (val[i] < vmin) vmin = val[i] ;
        if (val[i] > vmax) vmax = val[i] ;
      }
      System.out.println("End reading mesh values.") ;

      // We assume here that the max value means "undefined"
      // Thus we search fo the maximum valid value (i.e. the greatest
      // one but lower than undefined_value)

      undefined_value = vmax;
      vmax = vmin;
      for (i=0; i<num_val; i++)
        if (vmax < val[i] && val[i] < undefined_value)
          vmax = val[i];

      // Initialize the mesh
      mesh = new PoParalCartesianGrid2D();
      mesh.setGeometry(numX, numY, x,y);
      mesh.addValuesSet(0, val);

    }
    catch (java.io.IOException ex) {
      System.err.println(ex + "on file " + topoFile + "or " + dataFile);
    }

    return mesh;
  }

  private URL getURL(String fileName) {
    URL url = null;
    try {
      url = new URL("file:"+(new File(fileName)).getAbsolutePath()) ;
    }
    catch (MalformedURLException exc) {
      System.err.println(exc + " : (" + url + ") " + fileName + " invalid URL");
      url = null;
    }
    catch (Exception e) {
      System.err.println(e + " : cant load File "+ fileName);
      url = null;
    }
    return url;
  }
}
