package meshviz.mesh.sample.meshSides;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.data.PoMeshSides;
import com.openinventor.meshviz.nodes.PoTriangleMesh2D;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.sample.MeshViewer;
import util.Example;
import util.ViewerComponentsFactory;
/**
  * Draws the sides of a triangular mesh.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  float vmin,vmax;
  private IViewerExaminer myViewer;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Mesh Sides");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    String oivjhome = SoPreferences.getValue("OIVJHOME");
    PoTriangleMesh2D mesh = readFiles(oivjhome + "/data/mesh/TRIANGLE.TOPO",
        oivjhome + "/data/mesh/TRIANGLE0.DAT");
    if (mesh == null) return;

    // define the mesh sides
    PoMeshSides meshSides = new PoMeshSides();
    meshSides.zValuesIndex.setValue((short) 0);

    // build the scene-graph root
    SoSeparator root = new SoSeparator();
    root.addChild(mesh);
    root.addChild(meshSides);

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private PoTriangleMesh2D readFiles (String topoFile, String dataFile) {
    URL url_topo = MeshViewer.getURL(topoFile);
    if (url_topo == null) return null;

    URL url_data = MeshViewer.getURL(dataFile);
    if (url_data == null) return null;

    PoTriangleMesh2D mesh = null;

    AsciiStreamReader stream = null;
    try {
      int i;

      stream = new AsciiStreamReader(url_topo.openStream()) ;
      System.out.println("Start reading file "+topoFile+"...");

      // Read number of nodes and triangles
      int numTriangles = stream.readNextInt ();
      int numNodes = stream.readNextInt ();
      System.out.println("Reading "+numTriangles+" triangles and "+numNodes+" nodes");

      // Read triangles
      int[] triangleNode = new int[numTriangles*3];
      for (i=0 ; i<(3*numTriangles) ; i++)
	triangleNode[i] = stream.readNextInt ();

      // Read nodes
      float [] x = new float[numNodes];
      float [] y = new float[numNodes];

      for (i = 0; i < numNodes; i++) {
	x[i] = stream.readNextFloat ();
	y[i] = stream.readNextFloat ();
      }

      stream = new AsciiStreamReader(url_data.openStream()) ;
      System.out.println("Start reading file "+dataFile+"...");

      int np = stream.readNextInt() ;
      float [] v = new float[np] ;
      for(i=0 ; i<np ; i++) {
	v[i] = stream.readNextFloat ();
	if (v[i] < vmin) vmin = v[i] ;
	if (v[i] > vmax) vmax = v[i] ;
      }

      mesh = new PoTriangleMesh2D();
      mesh.setGeometry(numNodes, x, y, numTriangles, triangleNode);
      mesh.addValuesSet(0,v);
    }
    catch (Exception e) {
      System.err.println (e.toString());
      mesh = null;
    }

    return mesh;

  }
}
