package meshviz.mesh.sample.meshSkeleton;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.data.PbMesh;
import com.openinventor.meshviz.data.PoMesh;
import com.openinventor.meshviz.data.PoMeshSkeleton;
import com.openinventor.meshviz.nodes.PoNonLinearDataMapping2;
import com.openinventor.meshviz.nodes.PoTetrahedronMesh3D;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.sample.MeshViewer;
import util.Example;
import util.ViewerComponentsFactory;
/**
  * Draws a wireframe skeleton of a mesh made up of tetrahedrons
  * The skeleton is colored, using a color mapping.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Mesh Skeleton");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoTetrahedronMesh3D mesh = readFile(SoPreferences.getValue("OIVJHOME") + "/data/mesh/MESH_TETR.DAT");
    if (mesh == null) return;

    PbMesh pb_mesh = mesh.getMesh();

    // get the min-max value of this set
    float vmin = pb_mesh.getMinValuesSet(0);
    float vmax = pb_mesh.getMaxValuesSet(0);

    // define a data-mapping associated to this data-set
    SbColor[] colors = { new SbColor(0,0,1), new SbColor(0,1,1), new SbColor(0,1,0),
			 new SbColor(1,1,0), new SbColor(1,0,0)} ;
    float[] val = new float[5] ;
    val[0] = vmin; for (int j=1 ; j<5 ; j++) val[j] = val[j-1] + (vmax-vmin)/4;

    PoNonLinearDataMapping2 v_DataMapping = new PoNonLinearDataMapping2();
    v_DataMapping.type.setValue(PoNonLinearDataMapping2.Types.LINEAR_PER_LEVEL);
    v_DataMapping.color.setValues(0,colors);
    v_DataMapping.value.setValues(0,val);

    // define the mesh skeleton
    PoMeshSkeleton v_MeshSkeleton = new PoMeshSkeleton();
    v_MeshSkeleton.valuesIndex.setValue(0);
    v_MeshSkeleton.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);

    // build the scene-graph root
    SoGroup root = new SoGroup();
    {
      root.addChild(v_DataMapping);
      root.addChild(mesh);
      root.addChild(v_MeshSkeleton);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private synchronized PoTetrahedronMesh3D readFile(String dataFile) {
    URL data_url = MeshViewer.getURL(dataFile);
    if (data_url == null) return null;

    PoTetrahedronMesh3D mesh = null;
    AsciiStreamReader stream = null;

    try {
      int i;

      stream = new AsciiStreamReader(data_url.openStream()) ;

      // Read number of nodes and tetahedrons
      int numNodes = stream.readNextInt();
      int numTetrahedrons = stream.readNextInt();
      System.out.println("Reading "+numTetrahedrons+" tetahedrons and "+numNodes+" nodes");

      // Read nodes
      float[] x = new float[numNodes];
      float[] y = new float[numNodes];
      float[] z = new float[numNodes];

      for (i = 0; i < numNodes; i++) {
	x[i] = stream.readNextFloat();
	y[i] = stream.readNextFloat();
	z[i] = stream.readNextFloat();
      }

      System.out.println("reading nodes vectors");
      SbVec3f[] vec = new SbVec3f[numNodes];
      float vx,vy,vz;
      for (i=0 ; i<numNodes ; i++) {
	vx = stream.readNextFloat();
	vy = stream.readNextFloat();
	vz = stream.readNextFloat();
	vec[i] = new SbVec3f(vx, vy, vz) ;
      }

      System.out.println("reading value");
      float[][] v = new float[4][numNodes] ;

      for(i=0 ; i<numNodes ; i++) v[0][i] = stream.readNextFloat() ;
      for(i=0 ; i<numNodes ; i++) v[1][i] = stream.readNextFloat() ;
      for(i=0 ; i<numNodes ; i++) v[2][i] = stream.readNextFloat() ;
      for(i=0 ; i<numNodes ; i++) v[3][i] = stream.readNextFloat() ;

      for(i=0 ; i<numNodes ; i++)
        stream.readNextInt() ;

      System.out.println("reading tetahedrons nodes indices");
      int[] tetrahedronNode = new int[numTetrahedrons*4] ;
      for(i=0 ; i<(numTetrahedrons*4) ; i+=4) {
	tetrahedronNode[i] = stream.readNextInt() ;
	tetrahedronNode[i+1] = stream.readNextInt() ;
	tetrahedronNode[i+2] = stream.readNextInt() ;
	tetrahedronNode[i+3] = stream.readNextInt() ;
      }

      System.out.println("End reading mesh.") ;

      mesh = new PoTetrahedronMesh3D();
      mesh.setGeometry(numNodes, x, y, z, numTetrahedrons, tetrahedronNode);
      mesh.addValuesSet(0,v[0]);

    }
    catch (Exception e) {
      System.err.println (e.toString());
      mesh = null;
    }

    return mesh;
  }
}
