package meshviz.mesh.sample.paralCartesianGrid2DVec;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.nodes.PoParalCartesianGrid2D;

import meshviz.mesh.sample.Vec2DViewer;
import util.Example;
/**
  * Draws a vector field on a 2D parallel grid mesh. Draws the edges
  * of the mesh. Controls the aspect of the arrows representing
  * the vector field.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private Vec2DViewer viewer;

  @Override
  public void start() {
    int numX = 3, numY = 3 ;
    float[] x = {0.0F,0.5F,1.0F} ;
    float[] y = {0.0F,0.5F,1.0F} ;
    float[] val = new float[numX*numY], alt = new float[numX*numY] ;
    SbVec3f[] vec = new SbVec3f[numX*numY] ;

    PoParalCartesianGrid2D mesh = new PoParalCartesianGrid2D();
    mesh.setGeometry(numX, numY, x, y) ;

    for (int i=0 ; i<numX ; i++)
      for (int j=0 ; j<numY ; j++) {
	int ij = i*numX + j;
	val[ij] = i * (numY-j);
	alt[ij] = 0;
	vec[ij] = new SbVec3f(0.05F*(j+1), 0.05F*(i+1), 0F);
      }
    alt[numX+1] = 0.5F ;

    mesh.addValuesSet(0,val);
    mesh.addValuesSet(1,alt);
    mesh.addVecsSet(0,vec);

    viewer = new Vec2DViewer();
    viewer.setFileName("PoParalCartesianGrid2D.iv") ;
    viewer.show(mesh) ;
    viewer.getViewer().viewAll();

    viewer.getViewer().getComponent().setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(viewer);
  }

  @Override
  public void stop()
  {
    viewer.getViewer().dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PoParalCartesianGrid2D");
  }
}
