package meshviz.mesh.sample.tetrahedronMesh3DVec;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.nodes.PoTetrahedronMesh3D;

import meshviz.mesh.sample.Vec3DViewer;
import util.Example;

/**
  * Draws a vector field on a 3D indexed mesh (made up of tetrahedrons).
  * Controls the aspect of the arrows representing the vector field.
  * The mesh skin is also drawn and can be transparent.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private Vec3DViewer viewer;

  @Override
  public void start() {
    int numNodes = 5, numCells = 2 ;
    float[] x = { 0,1,-1,0, 2};
    float[] y = { 0,0,0,2, 0};
    float[] z = { 1,-1,0,0, 1};
    int[] cellIndex = {0,2,1,3, 0,1,4,3};

    SbVec3f[] vec = new SbVec3f[numNodes] ;
    float[] val = {0,1,1,2,5};
    vec[0] = new SbVec3f(0.1F,0.2F,0.3F);
    vec[1] = new SbVec3f(0.3F,-0.1F,0.2F);
    vec[2] = new SbVec3f(0, 0.2F, -0.5F);
    vec[3] = new SbVec3f(-0.3F, 0.1F, 0.2F);
    vec[4] = new SbVec3f(-0.3F, -0.1F, 0.3F);

    PoTetrahedronMesh3D mesh = new PoTetrahedronMesh3D();
    mesh.setGeometry(numNodes, x, y, z, numCells, cellIndex);
    mesh.addValuesSet(0,val);
    mesh.addVecsSet(0,vec);

    viewer = new Vec3DViewer();
    viewer.setFileName("PoTetrahedronMesh3D.iv") ;
    viewer.show(mesh) ;
    viewer.getViewer().viewAll();

    setLayout(new BorderLayout());
    viewer.getViewer().getComponent().setPreferredSize(new java.awt.Dimension(600, 500));
    add(viewer);
  }

  @Override
  public void stop()
  {
    viewer.getViewer().dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PoTetrahedronMesh3D");
  }
}
