package meshviz.mesh.sample.triangleMesh2DVec;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.nodes.PoTriangleMesh2D;

import meshviz.mesh.sample.Vec2DViewer;
import util.Example;

/**
  * Draws a vector field on a 2D indexed mesh (made up of
  * triangles). Draws the edges of the mesh. Controls the
  * aspect of the arrows representing the vector field.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private Vec2DViewer viewer;

  @Override
  public void start() {
    int numNodes = 5, numCells = 3 ;
    float[] x = {0,0,2,2,1};
    float[] y = {0,2,2,0,1};
    int[] cellIndex = {0,1,4, 4,2,3, 1,2,4};

    float[] val = {0,1,1,2,5};
    float[] alt = {0,1,1,0,0};
    SbVec3f[] vec = new SbVec3f[numNodes] ;

    vec[0] = new SbVec3f(0.1F,0.2F,0F);
    vec[1] = new SbVec3f(0.3F,-0.1F,0F);
    vec[2] = new SbVec3f(0, 0.2F,0F);
    vec[3] = new SbVec3f(-0.3F, 0.1F,0F);
    vec[4] = new SbVec3f(-0.3F, -0.1F,0F);

    PoTriangleMesh2D mesh = new PoTriangleMesh2D();
    mesh.setGeometry(numNodes, x, y, numCells, cellIndex) ;

    mesh.addValuesSet(0,val);
    mesh.addValuesSet(1,alt);
    mesh.addVecsSet(0,vec);

    viewer = new Vec2DViewer();
    viewer.setFileName("PoTriangleMesh2D.iv") ;
    viewer.show(mesh) ;
    viewer.getViewer().viewAll();

    setLayout(new BorderLayout());
    viewer.getViewer().getComponent().setPreferredSize(new java.awt.Dimension(600, 500));
    add(viewer);
  }

  @Override
  public void stop()
  {
    viewer.getViewer().dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PoTriangleMesh2D");
  }
}
