package meshvizxlm.eclipsemeshviz;

public class DemoSettings
{
  public enum GridType
  {
    E_GRID, JIK_GRID
  };

  public enum MeshType
  {
    FULLCACHE, TOPOCACHE, NOCACHE
  }

  public final static GridType GRID_TYPE = GridType.JIK_GRID;

  public final static boolean HORIZONTAL_FAULTS = false;

  public final static boolean LOW_RES_TIMINGS = false;

  public final static String DEFAULT_EGRID_FILE_NAME = "demo_grid_1M.bin";
  public final static String DEFAULT_JIK_FILE_NAME = "demo_grid_1M.jik.bin";

  public static final MeshType DEFAULT_MESH_TYPE = MeshType.TOPOCACHE;

  public static final boolean SHOW_MESHTYPE_PANEL = false;

  private static boolean s_display_timer = true;

  public static void displayTime(String what, double elapsedTime)
  {
    double seconds = elapsedTime / 1000;
    if ( s_display_timer )
      System.out.println(what + " in " + seconds + " seconds");
  }

  public static final int BACK_TO_FULL_RES_TIME = 5; // sec

  public static final double LOW_RESOLUTION_EXTRACTION_TIME_REFERENCE1 = 100; // ms

}
