package meshvizxlm.eclipsemeshviz.gui;

import java.awt.FlowLayout;
import java.util.ArrayList;

import javax.swing.JPanel;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

@SuppressWarnings("serial")
public class GeometryPanel extends JPanel
{

  private SliderPanel m_zScalingSliderPanel;

  private ArrayList<GeometryListener> m_listeners;

  /**
   * Create the panel.
   */
  public GeometryPanel()
  {
    m_listeners = new ArrayList<GeometryPanel.GeometryListener>();

    buildUI();
    addListeners();
  }

  public void addGeometryListener(GeometryListener listener)
  {
    m_listeners.add(listener);
  }

  @Override
  public String toString()
  {
    return "Geometry";
  }

  private void buildUI()
  {
    FlowLayout flowLayout = (FlowLayout) getLayout();
    flowLayout.setAlignment(FlowLayout.LEADING);

    m_zScalingSliderPanel = new SliderPanel(1.f, 50.f, 1.f, 3);
    add(m_zScalingSliderPanel);
    m_zScalingSliderPanel.addInfoText("Z scaling");
  }

  private void addListeners()
  {
    m_zScalingSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( GeometryListener listener : m_listeners )
          listener.zScalingChanged(value);
      }
    });
  }

  public interface GeometryListener
  {
    // fire when z scaling value changed
    public void zScalingChanged(float factor);
  }

}
