package meshvizxlm.eclipsemeshviz.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

import javax.swing.*;

import com.openinventor.inventor.SoPreferences;

import meshvizxlm.eclipsemeshviz.DemoSettings;
import meshvizxlm.eclipsemeshviz.DemoSettings.GridType;
import meshvizxlm.eclipsemeshviz.DemoSettings.MeshType;
import meshvizxlm.eclipsemeshviz.scenegraph.MeshReader;

@SuppressWarnings("serial")
public class MeshTypePanel extends JPanel
{
  private JTextField m_fileTextField;
  private JButton m_browseButton;
  private JRadioButton m_fullCacheMeshButton;
  private JRadioButton m_topologyCacheMeshButton;
  private JRadioButton m_noCacheMeshButton;
  private JComboBox<String> m_comboBoxPropertyChooser;

  private MeshListener m_listener;
  private File m_initialDirectory;
  private JButton m_saveasButton;

  /**
   * Create the panel.
   */
  public MeshTypePanel()
  {

    buildUI();
    addListeners();

    if ( DemoSettings.GRID_TYPE == GridType.E_GRID )
      m_fileTextField.setText(DemoSettings.DEFAULT_EGRID_FILE_NAME);
    else
      m_fileTextField.setText(DemoSettings.DEFAULT_JIK_FILE_NAME);
    switch ( DemoSettings.DEFAULT_MESH_TYPE )
    {
    case FULLCACHE :
      m_fullCacheMeshButton.setSelected(true);
      break;
    case NOCACHE :
      m_noCacheMeshButton.setSelected(true);
      break;
    default:
      m_topologyCacheMeshButton.setSelected(true);
    }

    m_initialDirectory = new File(SoPreferences.getValue("OIVJHOME") + "/examples/meshvizxlm/data/eclipsemeshviz");
    m_listener = MeshReader.getInstance();
  }

  @Override
  public String toString()
  {
    return "Mesh";
  }

  private void buildUI()
  {

    ButtonGroup meshGroup = new ButtonGroup();

    GridBagLayout gridBagLayout = new GridBagLayout();
    gridBagLayout.columnWidths = new int[] { 0, 0, 0, 0, 150, 0 };
    gridBagLayout.columnWeights = new double[] { 0.0, 1.0, 0.0, 0.0, 0.0, 0.0 };
    gridBagLayout.rowWeights = new double[] { 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0 };
    setLayout(gridBagLayout);

    JLabel lblNewLabel_2 = new JLabel("Data file");
    GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
    gbc_lblNewLabel_2.fill = GridBagConstraints.HORIZONTAL;
    gbc_lblNewLabel_2.insets = new Insets(5, 5, 5, 5);
    gbc_lblNewLabel_2.gridx = 0;
    gbc_lblNewLabel_2.gridy = 0;
    add(lblNewLabel_2, gbc_lblNewLabel_2);

    m_fileTextField = new JTextField();
    GridBagConstraints gbc_m_fileTextField = new GridBagConstraints();
    gbc_m_fileTextField.fill = GridBagConstraints.BOTH;
    gbc_m_fileTextField.gridwidth = 2;
    gbc_m_fileTextField.insets = new Insets(5, 0, 5, 5);
    gbc_m_fileTextField.gridx = 1;
    gbc_m_fileTextField.gridy = 0;
    add(m_fileTextField, gbc_m_fileTextField);
    m_fileTextField.setEditable(false);
    m_fileTextField.setColumns(10);

    m_browseButton = new JButton("Browse");
    GridBagConstraints gbc_m_browseButton = new GridBagConstraints();
    gbc_m_browseButton.anchor = GridBagConstraints.WEST;
    gbc_m_browseButton.insets = new Insets(5, 0, 5, 5);
    gbc_m_browseButton.gridx = 3;
    gbc_m_browseButton.gridy = 0;
    add(m_browseButton, gbc_m_browseButton);

    m_saveasButton = new JButton("Save As");
    GridBagConstraints gbc_m_saveasButton = new GridBagConstraints();
    gbc_m_saveasButton.anchor = GridBagConstraints.WEST;
    gbc_m_saveasButton.insets = new Insets(5, 0, 5, 5);
    gbc_m_saveasButton.gridx = 4;
    gbc_m_saveasButton.gridy = 0;
    add(m_saveasButton, gbc_m_saveasButton);

    JLabel lblNewLabel = new JLabel("Mesh types");
    GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
    gbc_lblNewLabel.fill = GridBagConstraints.BOTH;
    gbc_lblNewLabel.insets = new Insets(0, 5, 5, 5);
    gbc_lblNewLabel.gridx = 0;
    gbc_lblNewLabel.gridy = 2;

    m_fullCacheMeshButton = new JRadioButton("Full cache");
    m_fullCacheMeshButton.setToolTipText("Preprocessing for caching geometry and topology indexation, fastest display");
    GridBagConstraints gbc_m_fullCacheMeshButton = new GridBagConstraints();
    gbc_m_fullCacheMeshButton.weightx = 1.0;
    gbc_m_fullCacheMeshButton.anchor = GridBagConstraints.WEST;
    gbc_m_fullCacheMeshButton.insets = new Insets(0, 0, 5, 0);
    gbc_m_fullCacheMeshButton.gridwidth = 5;
    gbc_m_fullCacheMeshButton.gridx = 1;
    gbc_m_fullCacheMeshButton.gridy = 2;
    meshGroup.add(m_fullCacheMeshButton);

    m_topologyCacheMeshButton = new JRadioButton("Topology cache only");
    m_topologyCacheMeshButton.setToolTipText("No geometry cache, preprocessing for topology indexation.");
    GridBagConstraints gbc_m_topologyCacheMeshButton = new GridBagConstraints();
    gbc_m_topologyCacheMeshButton.insets = new Insets(0, 0, 5, 0);
    gbc_m_topologyCacheMeshButton.weightx = 1.0;
    gbc_m_topologyCacheMeshButton.anchor = GridBagConstraints.WEST;
    gbc_m_topologyCacheMeshButton.gridwidth = 5;
    gbc_m_topologyCacheMeshButton.gridx = 1;
    gbc_m_topologyCacheMeshButton.gridy = 3;
    meshGroup.add(m_topologyCacheMeshButton);

    m_noCacheMeshButton = new JRadioButton("No cache");
    m_noCacheMeshButton.setToolTipText("No geometry cache, no preprocessing for topology.");
    GridBagConstraints gbc_m_noCacheMeshButton = new GridBagConstraints();
    gbc_m_noCacheMeshButton.insets = new Insets(0, 0, 5, 0);
    gbc_m_noCacheMeshButton.weightx = 1.0;
    gbc_m_noCacheMeshButton.anchor = GridBagConstraints.WEST;
    gbc_m_noCacheMeshButton.gridwidth = 5;
    gbc_m_noCacheMeshButton.gridx = 1;
    gbc_m_noCacheMeshButton.gridy = 4;
    meshGroup.add(m_noCacheMeshButton);

    JLabel m_propertyChooser = new JLabel("Active Property");
    GridBagConstraints gbc_propertyChooser = new GridBagConstraints();
    gbc_propertyChooser.fill = GridBagConstraints.HORIZONTAL;
    gbc_propertyChooser.insets = new Insets(5, 5, 5, 5);
    gbc_propertyChooser.gridx = 0;
    gbc_propertyChooser.gridy = 2;
    add(m_propertyChooser, gbc_propertyChooser);

    String[] propertyList = { "Depth" };
    m_comboBoxPropertyChooser = new JComboBox<>(propertyList);
    m_comboBoxPropertyChooser.setSelectedIndex(0);
    GridBagConstraints gbc_comboBoxPropertyChooser = new GridBagConstraints();
    gbc_comboBoxPropertyChooser.fill = GridBagConstraints.HORIZONTAL;
    gbc_comboBoxPropertyChooser.insets = new Insets(5, 5, 5, 5);
    gbc_comboBoxPropertyChooser.gridx = 1;
    gbc_comboBoxPropertyChooser.gridy = 2;
    add(m_comboBoxPropertyChooser, gbc_comboBoxPropertyChooser);

    if ( DemoSettings.SHOW_MESHTYPE_PANEL )
    {
      add(lblNewLabel, gbc_lblNewLabel);
      add(m_fullCacheMeshButton, gbc_m_fullCacheMeshButton);
      add(m_topologyCacheMeshButton, gbc_m_topologyCacheMeshButton);
      add(m_noCacheMeshButton, gbc_m_noCacheMeshButton);
    }
  }

  private MeshType getMeshType()
  {
    if ( m_noCacheMeshButton.isSelected() )
      return MeshType.NOCACHE;
    if ( m_topologyCacheMeshButton.isSelected() )
      return MeshType.TOPOCACHE;
    return MeshType.FULLCACHE;
  }

  private void addListeners()
  {
    m_browseButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        JFileChooser fileChooser = new JFileChooser(m_initialDirectory);
        int ret = fileChooser.showOpenDialog(MeshTypePanel.this);

        if ( ret == JFileChooser.APPROVE_OPTION )
        {
          try
          {
            if ( m_listener != null )
              m_listener.meshChanged(getMeshType(), fileChooser.getSelectedFile());
            m_fileTextField.setText(fileChooser.getSelectedFile().getName());
          }
          catch (Exception exc)
          {
            System.err.println(exc.getMessage());
          }
        }
      }
    });

    m_saveasButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        JFileChooser fileChooser = new JFileChooser(m_initialDirectory);
        int ret = fileChooser.showSaveDialog(MeshTypePanel.this);

        if ( ret == JFileChooser.APPROVE_OPTION )
        {
          try
          {
            if ( m_listener != null )
              m_listener.meshSaved(fileChooser.getSelectedFile());
          }
          catch (Exception exc)
          {
            System.err.println(exc.getMessage());
          }
        }
      }
    });

    m_fullCacheMeshButton.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( e.getStateChange() == ItemEvent.SELECTED )
        {
          try
          {
            if ( m_listener != null )
              m_listener.meshTypeChanged(getMeshType());
          }
          catch (UnsupportedOperationException exc)
          {
            System.err.println(exc.getMessage());
          }
        }
      }
    });

    m_topologyCacheMeshButton.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( e.getStateChange() == ItemEvent.SELECTED )
        {
          try
          {
            if ( m_listener != null )
              m_listener.meshTypeChanged(getMeshType());
          }
          catch (UnsupportedOperationException exc)
          {
            System.err.println(exc.getMessage());
          }
        }
      }
    });

    m_noCacheMeshButton.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( e.getStateChange() == ItemEvent.SELECTED )
        {
          try
          {
            if ( m_listener != null )
              m_listener.meshTypeChanged(getMeshType());
          }
          catch (UnsupportedOperationException exc)
          {
            System.err.println(exc.getMessage());
          }
        }
      }
    });

    m_comboBoxPropertyChooser.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        String currentChoice = (String) m_comboBoxPropertyChooser.getSelectedItem();
        m_listener.propertyChanged(currentChoice);
      }
    });
  }

  public void updateComboBox()
  {
    boolean porosity = m_listener.isPorosityAvailable();
    if ( porosity == true )
    {
      int thereIsAPorosityAlready = 0;
      for ( int i = 0; i < m_comboBoxPropertyChooser.getItemCount(); i++ )
      {
        if ( m_comboBoxPropertyChooser.getItemAt(i).equals("Porosity") )
          thereIsAPorosityAlready++;
      }
      if ( thereIsAPorosityAlready == 0 )
        m_comboBoxPropertyChooser.addItem("Porosity");

      m_comboBoxPropertyChooser.setSelectedItem("Porosity");
    }
    else
      m_comboBoxPropertyChooser.removeItem("Porosity");
  }
}
