package meshvizxlm.eclipsemeshviz.isosurface;

import java.util.Arrays;

import com.openinventor.meshvizxlm.extractors.MiExtractorCallback;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetI;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetIjk;
import com.openinventor.meshvizxlm.mesh.topology.MiHexahedronTopologyExplicitIjk;

import meshvizxlm.eclipsemeshviz.scenegraph.OivSceneGraph;
import meshvizxlm.eclipsemeshviz.wrappers.EclipseMesh;

public class CellToNodeExtractor
{
  private PillarNodeProperty m_extracted;
  private MiExtractorCallback m_extractorCallback;

  public CellToNodeExtractor()
  {
    this(false);
  }

  public CellToNodeExtractor(boolean lowResExtractor)
  {
    m_extractorCallback = new OivSceneGraph.TimerCallback("Conversion", lowResExtractor);
    m_extracted = new PillarNodeProperty(new float[] { 0.0f });
  }

  public MiScalardSetI extract(EclipseMesh mesh)
  {
    long timeStamp = Math.max(mesh.getTopology().getTimeStamp(), mesh.getDataSet().getTimeStamp());
    if ( timeStamp != m_extracted.getTimeStamp() )
    {
      MiHexahedronTopologyExplicitIjk topology = mesh.getTopology();
      MiScalardSetIjk inputDataset = mesh.getDataSet();
      int numNodes = (int) topology.getEndNodeId();

      m_extractorCallback.beginCallback(false, false, true);
      long[] nodeIndices = new long[8];
      int[] weightsums = new int[numNodes];
      float[] outputScalarset;
      if ( numNodes > m_extracted.getScalars().length )
        outputScalarset = new float[numNodes];
      else
      {
        outputScalarset = m_extracted.getScalars();
        Arrays.fill(outputScalarset, 0);
      }

      int nodeIndex;
      final int numI = mesh.getDimI();
      final int numJ = mesh.getDimJ();
      final int numK = mesh.getDimK();
      for ( int i = 0; i < numI; i++ )
        for ( int j = 0; j < numJ; j++ )
          for ( int k = 0; k < numK; k++ )
          {
            topology.getCellNodeIndices(i, j, k, nodeIndices);
            for ( int cellNodeIndex = 0; cellNodeIndex < 8; cellNodeIndex++ )
            {
              nodeIndex = (int) nodeIndices[cellNodeIndex];
              outputScalarset[nodeIndex] += inputDataset.get(i, j, k);
              ++weightsums[nodeIndex];
            }
          }

      for ( nodeIndex = 0; nodeIndex < numNodes; nodeIndex++ )
        if ( weightsums[nodeIndex] > 0 )
          outputScalarset[nodeIndex] /= weightsums[nodeIndex];

      m_extractorCallback.endCallback(false, false, true);

      m_extracted.setScalars(outputScalarset);
      m_extracted.touch();
    }

    return m_extracted;
  }
}
