package meshvizxlm.eclipsemeshviz.isosurface;

import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetI;

import meshvizxlm.mesh.data.MbDataSet;

public class PillarNodeProperty extends MbDataSet implements MiScalardSetI
{
  private float[] m_scalars;

  public PillarNodeProperty(float[] nodeScalars)
  {
    m_scalars = nodeScalars;
  }

  @Override
  public DataBinding getBinding()
  {
    return DataBinding.PER_NODE;
  }

  @Override
  public double get(long i)
  {
    return m_scalars[(int) i];
  }

  float[] getScalars()
  {
    return m_scalars;
  }

  void setScalars(float[] scalars)
  {
    this.m_scalars = scalars;
  }
}
