package meshvizxlm.eclipsemeshviz.pillargrid;

interface LevelFunctor
{
  public float apply(float x, float y);

  public float getMin();

  public float getMax();
}

class ConstantFctor implements LevelFunctor
{
  private float m_cst;

  public ConstantFctor(float cst)
  {
    m_cst = cst;
  }

  @Override
  public float apply(float x, float y)
  {
    return m_cst;
  }

  @Override
  public float getMin()
  {
    return m_cst;
  }

  @Override
  public float getMax()
  {
    return m_cst;
  }
}

class CosFctor implements LevelFunctor
{
  private float m_cst;
  private float m_alpha;
  private float m_beta;

  public CosFctor(float alpha, float beta, float cst)
  {
    m_cst = cst;
    m_alpha = alpha;
    m_beta = beta;
  }

  @Override
  public float apply(float x, float y)
  {
    return (float) (m_beta * Math.cos(m_alpha * x) + m_cst);
  }

  @Override
  public float getMin()
  {
    return -m_beta + m_cst;
  }

  @Override
  public float getMax()
  {
    return m_beta + m_cst;
  }
}

class SinFctor implements LevelFunctor
{
  private float m_cst;
  private float m_alpha;
  private float m_beta;

  public SinFctor(float alpha, float beta, float cst)
  {
    m_cst = cst;
    m_alpha = alpha;
    m_beta = beta;
  }

  @Override
  public float apply(float x, float y)
  {
    return (float) (m_beta * Math.sin(m_alpha * x) + m_cst);
  }

  @Override
  public float getMin()
  {
    return -m_beta + m_cst;
  }

  @Override
  public float getMax()
  {
    return m_beta + m_cst;
  }
}

class CosSinFctor implements LevelFunctor
{
  private float m_cst;
  private SinFctor m_sinor;
  private CosFctor m_cosor;

  public CosSinFctor(float cosAlpha, float cosBeta, float sinAlpha, float sinBeta, float cst)
  {
    m_cst = cst;
    m_sinor = new SinFctor(sinAlpha, sinBeta, 0);
    m_cosor = new CosFctor(cosAlpha, cosBeta, 0);
  }

  @Override
  public float apply(float x, float y)
  {
    return m_cosor.apply(x, y) * m_sinor.apply(y, x) + m_cst;
  }

  @Override
  public float getMin()
  {
    return m_sinor.getMin() * m_cosor.getMin() + m_cst;
  }

  @Override
  public float getMax()
  {
    return m_sinor.getMax() * m_cosor.getMax() + m_cst;
  }
}
